/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.builder.AbstractPipelineElementBuilder;

public class DataStreamBuilder
extends AbstractPipelineElementBuilder<DataStreamBuilder, SpDataStream> {
    private List<EventProperty> eventProperties = new ArrayList<EventProperty>();
    private EventGrounding eventGrounding = new EventGrounding();

    protected DataStreamBuilder(String id, String label, String description) {
        super(id, label, description, new SpDataStream());
    }

    public static DataStreamBuilder create(String id, String label, String description) {
        return new DataStreamBuilder(id, label, description);
    }

    public DataStreamBuilder property(EventProperty property) {
        this.eventProperties.add(property);
        return this.me();
    }

    public DataStreamBuilder properties(List<EventProperty> properties) {
        this.eventProperties.addAll(properties);
        return this.me();
    }

    public DataStreamBuilder protocol(TransportProtocol protocol) {
        this.eventGrounding.setTransportProtocol(protocol);
        return this;
    }

    public DataStreamBuilder format(TransportFormat format) {
        this.eventGrounding.setTransportFormats(Collections.singletonList(format));
        return this;
    }

    @Override
    protected DataStreamBuilder me() {
        return this;
    }

    @Override
    protected void prepareBuild() {
        ((SpDataStream)this.elementDescription).setEventGrounding(this.eventGrounding);
        for (int i = 0; i < this.eventProperties.size(); ++i) {
            this.eventProperties.get(i).setIndex(i);
        }
        ((SpDataStream)this.elementDescription).setEventSchema(new EventSchema(this.eventProperties));
    }
}

