/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.streampipes.model.quality.Accuracy;
import org.streampipes.model.quality.EventPropertyQualityDefinition;
import org.streampipes.model.quality.Resolution;
import org.streampipes.model.schema.Enumeration;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.schema.PropertyScope;
import org.streampipes.model.schema.QuantitativeValue;
import org.streampipes.model.schema.ValueSpecification;
import org.streampipes.sdk.utils.Datatypes;

public class PrimitivePropertyBuilder {
    EventPropertyPrimitive eventProperty = new EventPropertyPrimitive();
    List<EventPropertyQualityDefinition> qualityDefinitions = new ArrayList<EventPropertyQualityDefinition>();

    private PrimitivePropertyBuilder(Datatypes datatype, String runtimeName) {
        this.eventProperty.setRuntimeType(datatype.toString());
        this.eventProperty.setRuntimeName(runtimeName);
    }

    public static PrimitivePropertyBuilder create(Datatypes datatype, String runtimeName) {
        return new PrimitivePropertyBuilder(datatype, runtimeName);
    }

    public PrimitivePropertyBuilder domainProperty(String domainProperty) {
        this.eventProperty.setDomainProperties(Collections.singletonList(URI.create(domainProperty)));
        return this;
    }

    public PrimitivePropertyBuilder measurementUnit(URI measurementUnit) {
        this.eventProperty.setMeasurementUnit(measurementUnit);
        return this;
    }

    public PrimitivePropertyBuilder valueSpecification(Float min, Float max, Float step) {
        this.eventProperty.setValueSpecification((ValueSpecification)new QuantitativeValue(min, max, step));
        return this;
    }

    public PrimitivePropertyBuilder valueSpecification(String label, String description, List<String> allowedValues) {
        this.eventProperty.setValueSpecification((ValueSpecification)new Enumeration(label, description, allowedValues));
        return this;
    }

    public PrimitivePropertyBuilder label(String label) {
        this.eventProperty.setLabel(label);
        return this;
    }

    public PrimitivePropertyBuilder description(String description) {
        this.eventProperty.setDescription(description);
        return this;
    }

    public PrimitivePropertyBuilder accuracy(Float accuracy, URI measurementUnit) {
        this.qualityDefinitions.add((EventPropertyQualityDefinition)new Accuracy(accuracy.floatValue()));
        return this;
    }

    public PrimitivePropertyBuilder resolution(Float resolution, URI measurementUnit) {
        this.qualityDefinitions.add((EventPropertyQualityDefinition)new Resolution(resolution.floatValue()));
        return this;
    }

    public PrimitivePropertyBuilder scope(PropertyScope propertyScope) {
        this.eventProperty.setPropertyScope(propertyScope.name());
        return this;
    }

    public EventPropertyPrimitive build() {
        if (this.qualityDefinitions.size() > 0) {
            this.eventProperty.setEventPropertyQualities(this.qualityDefinitions);
        }
        return this.eventProperty;
    }
}

