/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.sdk.helpers.Label;
import org.streampipes.sdk.helpers.Locales;

public abstract class AbstractPipelineElementBuilder<BU extends AbstractPipelineElementBuilder<BU, T>, T extends NamedStreamPipesEntity> {
    protected T elementDescription;

    protected AbstractPipelineElementBuilder(String appId, String label, String description, T element) {
        this(appId, element);
        this.elementDescription.setName(label);
        this.elementDescription.setDescription(description);
    }

    protected AbstractPipelineElementBuilder(String appId, T element) {
        this.elementDescription = element;
        this.elementDescription.setElementId(appId);
        this.elementDescription.setAppId(appId);
    }

    public BU iconUrl(String iconUrl) {
        this.elementDescription.setIconUrl(iconUrl);
        return this.me();
    }

    @Deprecated
    public BU providesAssets(String ... assets) {
        return this.withAssets(assets);
    }

    public BU withAssets(String ... assets) {
        this.elementDescription.setIncludesAssets(true);
        this.elementDescription.setIncludedAssets(Arrays.asList(assets));
        return this.me();
    }

    public BU withLocales(Locales ... locales) {
        this.elementDescription.setIncludesLocales(true);
        this.elementDescription.setIncludedLocales(Stream.of(locales).map(Locales::toFilename).collect(Collectors.toList()));
        return this.me();
    }

    protected <SP extends StaticProperty> SP prepareStaticProperty(Label label, SP element) {
        element.setInternalName(label.getInternalId());
        element.setDescription(label.getDescription());
        element.setLabel(label.getLabel());
        return element;
    }

    protected abstract BU me();

    protected abstract void prepareBuild();

    public T build() {
        this.prepareBuild();
        return this.elementDescription;
    }
}

