/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import org.streampipes.model.grounding.TopicParameterType;
import org.streampipes.model.grounding.WildcardTopicDefinition;
import org.streampipes.model.grounding.WildcardTopicMapping;

public class WildcardTopicBuilder {
    private WildcardTopicDefinition wildcardTopicDefinition = new WildcardTopicDefinition();

    private WildcardTopicBuilder(String wildcardTopic) {
        this.wildcardTopicDefinition.setWildcardTopicName(wildcardTopic);
    }

    public static WildcardTopicBuilder create(String wildcardTopic) {
        return new WildcardTopicBuilder(wildcardTopic);
    }

    public WildcardTopicBuilder addMapping(WildcardTopicMapping topicMapping) {
        this.wildcardTopicDefinition.getWildcardTopicMappings().add(topicMapping);
        return this;
    }

    public WildcardTopicBuilder addSimpleMapping(TopicParameterType topicParameterType, String runtimeName) {
        this.wildcardTopicDefinition.getWildcardTopicMappings().add(new WildcardTopicMapping(topicParameterType.name(), runtimeName, runtimeName));
        return this;
    }

    public WildcardTopicBuilder addPlatformIdMapping(String runtimeName) {
        return this.addSimpleMapping(TopicParameterType.PLATFORM_IDENTIFIER, runtimeName);
    }

    public WildcardTopicBuilder addSensorIdMapping(String runtimeName) {
        return this.addSimpleMapping(TopicParameterType.SENSOR_IDENTIFIER, runtimeName);
    }

    public WildcardTopicBuilder addLocationIdMapping(String runtimeName) {
        return this.addSimpleMapping(TopicParameterType.LOCATION_IDENTIFIER, runtimeName);
    }

    public WildcardTopicBuilder addPlatformTypeMapping(String runtimeName) {
        return this.addSimpleMapping(TopicParameterType.PLATFORM_TYPE, runtimeName);
    }

    public WildcardTopicBuilder addSensorTypeMapping(String runtimeName) {
        return this.addSimpleMapping(TopicParameterType.SENSOR_TYPE, runtimeName);
    }

    public WildcardTopicDefinition build() {
        return this.wildcardTopicDefinition;
    }
}

