/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.helpers;

import org.streampipes.commons.Utils;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.sdk.utils.Datatypes;
import org.streampipes.vocabulary.XSD;

public class EpRequirements {
    public static EventPropertyList listRequirement() {
        return new EventPropertyList();
    }

    public static EventPropertyList nestedListRequirement() {
        EventPropertyList listEp = new EventPropertyList();
        listEp.setEventProperty((EventProperty)new EventPropertyNested());
        return listEp;
    }

    public static EventPropertyList listRequirement(Datatypes datatype) {
        return new EventPropertyList("", (EventProperty)EpRequirements.datatypeReq(datatype));
    }

    public static EventProperty listRequirement(EventProperty listItemType) {
        return new EventPropertyList(listItemType);
    }

    public static EventPropertyPrimitive datatypeReq(String datatype) {
        EventPropertyPrimitive ep = new EventPropertyPrimitive();
        ep.setRuntimeType(datatype);
        return ep;
    }

    public static EventPropertyPrimitive datatypeReq(Datatypes datatype) {
        return EpRequirements.datatypeReq(datatype.toString());
    }

    public static EventPropertyPrimitive booleanReq() {
        return EpRequirements.datatypeReq(XSD._boolean.toString());
    }

    public static EventPropertyPrimitive integerReq() {
        return EpRequirements.datatypeReq(XSD._integer.toString());
    }

    public static EventPropertyPrimitive doubleReq() {
        return EpRequirements.datatypeReq(XSD._double.toString());
    }

    public static EventPropertyPrimitive stringReq() {
        return EpRequirements.datatypeReq(XSD._string.toString());
    }

    public static EventPropertyPrimitive numberReq() {
        return EpRequirements.datatypeReq("http://schema.org/Number");
    }

    public static EventPropertyPrimitive anyProperty() {
        return new EventPropertyPrimitive();
    }

    public static EventPropertyPrimitive booleanReq(String domainProperty) {
        return EpRequirements.appendDomainProperty(EpRequirements.datatypeReq(XSD._boolean.toString()), domainProperty);
    }

    public static EventPropertyPrimitive integerReq(String domainProperty) {
        return EpRequirements.appendDomainProperty(EpRequirements.datatypeReq(XSD._integer.toString()), domainProperty);
    }

    public static EventPropertyPrimitive doubleReq(String domainProperty) {
        return EpRequirements.appendDomainProperty(EpRequirements.datatypeReq(XSD._double.toString()), domainProperty);
    }

    public static EventPropertyPrimitive stringReq(String domainProperty) {
        return EpRequirements.appendDomainProperty(EpRequirements.datatypeReq(XSD._string.toString()), domainProperty);
    }

    public static EventPropertyPrimitive numberReq(String domainProperty) {
        return EpRequirements.appendDomainProperty(EpRequirements.datatypeReq("http://schema.org/Number"), domainProperty);
    }

    private static <T extends EventProperty> EventProperty domainPropertyReq(String domainProperty, Class<T> eventProperty) {
        EventProperty ep = null;
        try {
            ep = (EventProperty)eventProperty.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        ep.setDomainProperties(Utils.createURI((String[])new String[]{domainProperty}));
        return ep;
    }

    public static EventPropertyPrimitive domainPropertyReq(String domainProperty) {
        return (EventPropertyPrimitive)EpRequirements.domainPropertyReq(domainProperty, EventPropertyPrimitive.class);
    }

    public static EventPropertyList domainPropertyReqList(String domainProperty) {
        return (EventPropertyList)EpRequirements.domainPropertyReq(domainProperty, EventPropertyList.class);
    }

    private static EventPropertyPrimitive appendDomainProperty(EventPropertyPrimitive property, String domainProperty) {
        property.setDomainProperties(Utils.createURI((String[])new String[]{domainProperty}));
        return property;
    }

    public static EventPropertyPrimitive timestampReq() {
        return EpRequirements.domainPropertyReq("http://schema.org/DateTime");
    }
}

