/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.staticproperty.AnyStaticProperty;
import org.streampipes.model.staticproperty.CollectionStaticProperty;
import org.streampipes.model.staticproperty.DomainStaticProperty;
import org.streampipes.model.staticproperty.FileStaticProperty;
import org.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.streampipes.model.staticproperty.OneOfStaticProperty;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.staticproperty.PropertyValueSpecification;
import org.streampipes.model.staticproperty.RuntimeResolvableOneOfStaticProperty;
import org.streampipes.model.staticproperty.SecretStaticProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyAlternative;
import org.streampipes.model.staticproperty.StaticPropertyAlternatives;
import org.streampipes.model.staticproperty.SupportedProperty;
import org.streampipes.sdk.builder.AbstractPipelineElementBuilder;
import org.streampipes.sdk.helpers.Label;
import org.streampipes.sdk.helpers.Labels;
import org.streampipes.vocabulary.XSD;

public abstract class AbstractConfigurablePipelineElementBuilder<BU extends AbstractConfigurablePipelineElementBuilder<BU, T>, T extends NamedStreamPipesEntity>
extends AbstractPipelineElementBuilder<BU, T> {
    protected List<StaticProperty> staticProperties = new ArrayList<StaticProperty>();

    protected AbstractConfigurablePipelineElementBuilder(String appId, String label, String description, T element) {
        super(appId, label, description, element);
    }

    protected AbstractConfigurablePipelineElementBuilder(String appId, T element) {
        super(appId, element);
    }

    public BU requiredStaticProperty(StaticProperty staticProperty) {
        this.staticProperties.add(staticProperty);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredOntologyConcept(Label label, SupportedProperty ... supportedOntologyProperties) {
        DomainStaticProperty dsp = this.prepareStaticProperty(label, new DomainStaticProperty());
        dsp.setSupportedProperties(Arrays.asList(supportedOntologyProperties));
        this.staticProperties.add((StaticProperty)dsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredOntologyConcept(Label label, String requiredConceptUri, SupportedProperty ... supportedOntologyProperties) {
        DomainStaticProperty dsp = this.prepareStaticProperty(label, new DomainStaticProperty());
        dsp.setSupportedProperties(Arrays.asList(supportedOntologyProperties));
        dsp.setRequiredClass(requiredConceptUri);
        this.staticProperties.add((StaticProperty)dsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredParameterAsCollection(Label label, StaticProperty staticProperty) {
        CollectionStaticProperty collection = this.prepareStaticProperty(label, new CollectionStaticProperty());
        collection.setStaticPropertyTemplate(staticProperty);
        this.staticProperties.add((StaticProperty)collection);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredTextParameter(String internalId, String label, String description) {
        this.staticProperties.add((StaticProperty)this.prepareFreeTextStaticProperty(internalId, label, description, XSD._string.toString()));
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredSecret(Label label) {
        SecretStaticProperty secretStaticProperty = new SecretStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        this.staticProperties.add((StaticProperty)secretStaticProperty);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredTextParameter(Label label) {
        this.staticProperties.add((StaticProperty)this.prepareFreeTextStaticProperty(label, XSD._string.toString()));
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredTextParameter(String internalId, String label, String description, String linkedMappingPropertyInternalName) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(internalId, label, description, XSD._string.toString());
        fsp.setMapsTo(linkedMappingPropertyInternalName);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredTextParameter(Label label, String linkedMappingPropertyInternalName) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label, XSD._string.toString());
        fsp.setMapsTo(linkedMappingPropertyInternalName);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredHtmlInputParameter(Label label) {
        FreeTextStaticProperty fsp = new FreeTextStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        fsp.setMultiLine(true);
        fsp.setHtmlAllowed(true);
        fsp.setPlaceholdersSupported(true);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredTextParameter(Label label, boolean multiLine, boolean placeholdersSupported) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label, XSD._string.toString());
        if (multiLine) {
            fsp.setMultiLine(true);
        }
        if (placeholdersSupported) {
            fsp.setPlaceholdersSupported(true);
        }
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(String internalId, String label, String description) {
        this.staticProperties.add((StaticProperty)this.prepareFreeTextStaticProperty(internalId, label, description, XSD._integer.toString()));
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(Label label) {
        this.staticProperties.add((StaticProperty)this.prepareFreeTextStaticProperty(label, XSD._integer.toString()));
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(String internalId, String label, String description, String linkedMappingPropertyInternalName) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(internalId, label, description, XSD._integer.toString());
        fsp.setMapsTo(linkedMappingPropertyInternalName);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(Label label, String linkedMappingPropertyInternalName) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label, XSD._integer.toString());
        fsp.setMapsTo(linkedMappingPropertyInternalName);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(String internalId, String label, String description, Integer defaultValue) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(internalId, label, description, XSD._integer.toString());
        fsp.setValue(String.valueOf(defaultValue));
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(Label label, Integer defaultValue) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label, XSD._integer.toString());
        fsp.setValue(String.valueOf(defaultValue));
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFloatParameter(String internalId, String label, String description) {
        this.staticProperties.add((StaticProperty)this.prepareFreeTextStaticProperty(internalId, label, description, XSD._double.toString()));
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFloatParameter(Label label) {
        this.staticProperties.add((StaticProperty)this.prepareFreeTextStaticProperty(label, XSD._double.toString()));
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFloatParameter(String internalId, String label, String description, String linkedMappingPropertyInternalName) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(internalId, label, description, XSD._double.toString());
        fsp.setMapsTo(linkedMappingPropertyInternalName);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFloatParameter(Label label, String linkedMappingPropertyInternalName) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label, XSD._double.toString());
        fsp.setMapsTo(linkedMappingPropertyInternalName);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFloatParameter(String internalId, String label, String description, Float defaultValue) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(internalId, label, description, XSD._double.toString());
        fsp.setValue(String.valueOf(defaultValue));
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFloatParameter(Label label, Float defaultValue) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label, XSD._double.toString());
        fsp.setValue(String.valueOf(defaultValue));
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredSingleValueSelection(String internalId, String label, String description, Option ... options) {
        return this.requiredSingleValueSelection(internalId, label, description, Arrays.asList(options));
    }

    public BU requiredSingleValueSelection(Label label, Option ... options) {
        return this.requiredSingleValueSelection(label.getInternalId(), label.getLabel(), label.getDescription(), Arrays.asList(options));
    }

    public BU requiredSingleValueSelection(String internalId, String label, String description, List<Option> options) {
        OneOfStaticProperty osp = new OneOfStaticProperty(internalId, label, description);
        osp.setOptions(options);
        this.staticProperties.add((StaticProperty)osp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredSingleValueSelection(Label label, List<Option> options) {
        OneOfStaticProperty osp = new OneOfStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        osp.setOptions(options);
        this.staticProperties.add((StaticProperty)osp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredMultiValueSelection(String internalId, String label, String description, Option ... options) {
        return this.requiredMultiValueSelection(internalId, label, description, Arrays.asList(options));
    }

    public BU requiredMultiValueSelection(Label label, Option ... options) {
        return this.requiredMultiValueSelection(label.getInternalId(), label.getLabel(), label.getDescription(), Arrays.asList(options));
    }

    public BU requiredMultiValueSelection(String internalId, String label, String description, List<Option> options) {
        AnyStaticProperty asp = new AnyStaticProperty(internalId, label, description);
        asp.setOptions(options);
        this.staticProperties.add((StaticProperty)asp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredMultiValueSelection(Label label, List<Option> options) {
        AnyStaticProperty asp = new AnyStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        asp.setOptions(options);
        this.staticProperties.add((StaticProperty)asp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(Label label, Integer min, Integer max, Integer step) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription(), XSD._integer.toString());
        PropertyValueSpecification valueSpecification = new PropertyValueSpecification((double)min.intValue(), (double)max.intValue(), (double)step.intValue());
        fsp.setValueSpecification(valueSpecification);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredIntegerParameter(String internalId, String label, String description, Integer min, Integer max, Integer step) {
        return this.requiredIntegerParameter(Labels.from(internalId, label, description), min, max, step);
    }

    public BU requiredFloatParameter(String internalId, String label, String description, Float min, Float max, Float step) {
        FreeTextStaticProperty fsp = this.prepareFreeTextStaticProperty(internalId, label, description, XSD._double.toString());
        PropertyValueSpecification valueSpecification = new PropertyValueSpecification((double)min.floatValue(), (double)max.floatValue(), (double)step.floatValue());
        fsp.setValueSpecification(valueSpecification);
        this.staticProperties.add((StaticProperty)fsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredFile(Label label) {
        FileStaticProperty fp = new FileStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        this.staticProperties.add((StaticProperty)fp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredAlternatives(Label label, StaticPropertyAlternative ... alternatives) {
        StaticPropertyAlternatives alternativesContainer = new StaticPropertyAlternatives(label.getInternalId(), label.getLabel(), label.getDescription());
        for (int i = 0; i < alternatives.length; ++i) {
            alternatives[i].setIndex(i);
        }
        alternativesContainer.setAlternatives(Arrays.asList(alternatives));
        this.staticProperties.add((StaticProperty)alternativesContainer);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredSingleValueSelectionFromContainer(Label label) {
        RuntimeResolvableOneOfStaticProperty rsp = new RuntimeResolvableOneOfStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        this.staticProperties.add((StaticProperty)rsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    public BU requiredSingleValueSelectionFromContainer(Label label, List<String> dependsOn) {
        RuntimeResolvableOneOfStaticProperty rsp = new RuntimeResolvableOneOfStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        rsp.setDependsOn(dependsOn);
        this.staticProperties.add((StaticProperty)rsp);
        return (BU)((AbstractConfigurablePipelineElementBuilder)this.me());
    }

    private FreeTextStaticProperty prepareFreeTextStaticProperty(String internalId, String label, String description, String type) {
        return new FreeTextStaticProperty(internalId, label, description, URI.create(type));
    }

    private FreeTextStaticProperty prepareFreeTextStaticProperty(Label label, String type) {
        return this.prepareFreeTextStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription(), type);
    }

    private List<StaticProperty> sortStaticProperties(List<StaticProperty> staticProperties) {
        for (int i = 0; i < staticProperties.size(); ++i) {
            staticProperties.get(i).setIndex(i);
        }
        return staticProperties;
    }

    protected List<StaticProperty> getStaticProperties() {
        return this.sortStaticProperties(this.staticProperties);
    }
}

