/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.streampipes.model.staticproperty.SelectionStaticProperty;
import org.streampipes.model.template.BoundPipelineElement;

public class BoundPipelineElementBuilder {
    private BoundPipelineElement boundPipelineElement;
    private InvocableStreamPipesEntity streamPipesEntity;
    private List<BoundPipelineElement> connectedTo;

    private BoundPipelineElementBuilder(InvocableStreamPipesEntity streamPipesEntity) {
        this.streamPipesEntity = streamPipesEntity;
        this.streamPipesEntity.setElementId(this.streamPipesEntity.getBelongsTo() + "/" + UUID.randomUUID().toString());
        this.boundPipelineElement = new BoundPipelineElement();
        this.connectedTo = new ArrayList<BoundPipelineElement>();
    }

    public static BoundPipelineElementBuilder create(DataProcessorDescription dataProcessorDescription) {
        return new BoundPipelineElementBuilder((InvocableStreamPipesEntity)new DataProcessorInvocation(dataProcessorDescription));
    }

    public static BoundPipelineElementBuilder create(DataSinkDescription dataSinkDescription) {
        return new BoundPipelineElementBuilder((InvocableStreamPipesEntity)new DataSinkInvocation(dataSinkDescription));
    }

    public BoundPipelineElementBuilder connectTo(BoundPipelineElement boundPipelineElement) {
        this.connectedTo.add(boundPipelineElement);
        return this;
    }

    public BoundPipelineElementBuilder withPredefinedFreeTextValue(String internalStaticPropertyId, String value) {
        this.streamPipesEntity.getStaticProperties().stream().filter(sp -> sp instanceof FreeTextStaticProperty).forEach(sp -> {
            if (sp.getInternalName().equals(internalStaticPropertyId)) {
                sp.setPredefined(true);
                ((FreeTextStaticProperty)sp).setValue(value);
            }
        });
        return this;
    }

    public BoundPipelineElementBuilder withPredefinedSelection(String internalStaticPropertyId, List<String> selectedOptions) {
        this.streamPipesEntity.getStaticProperties().stream().filter(sp -> sp instanceof SelectionStaticProperty).forEach(sp -> {
            if (sp.getInternalName().equals(internalStaticPropertyId)) {
                sp.setPredefined(true);
                ((SelectionStaticProperty)sp).getOptions().forEach(o -> {
                    if (selectedOptions.stream().anyMatch(so -> so.equals(o.getName()))) {
                        o.setSelected(true);
                    }
                });
            }
        });
        return this;
    }

    public BoundPipelineElementBuilder withOverwrittenLabel(String internalStaticPropertyId, String newLabel) {
        this.streamPipesEntity.getStaticProperties().forEach(sp -> {
            sp.setPredefined(true);
            if (sp.getInternalName().equals(internalStaticPropertyId)) {
                sp.setLabel(newLabel);
            }
        });
        return this;
    }

    public BoundPipelineElement build() {
        this.boundPipelineElement.setPipelineElementTemplate(this.streamPipesEntity);
        this.boundPipelineElement.setConnectedTo(this.connectedTo);
        return this.boundPipelineElement;
    }

    public BoundPipelineElement buildWithStandardSinks() {
        return this.build();
    }
}

