/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.helpers;

import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.sdk.helpers.Label;

public class Labels {
    private static final Logger LOG = LoggerFactory.getLogger(Labels.class);

    public static Label from(String internalId, String label, String description) {
        return new Label(internalId, label, description);
    }

    @Deprecated
    public static Label fromResources(String resourceIdentifier, String resourceName) {
        try {
            return new Label(resourceName, Labels.findTitleLabel(resourceIdentifier, resourceName), Labels.findDescriptionLabel(resourceIdentifier, resourceName));
        }
        catch (Exception e) {
            LOG.error("Could not find resource " + resourceIdentifier);
            return new Label(resourceName, "", "");
        }
    }

    public static Label withId(String internalId) {
        return new Label(internalId, "", "");
    }

    @Deprecated
    public static Label withTitle(String label, String description) {
        return new Label("", label, description);
    }

    public static Label empty() {
        return new Label("", "", "");
    }

    private static String findTitleLabel(String resourceIdentifier, String resourceName) throws Exception {
        return Labels.loadProperties(resourceIdentifier).getProperty(Labels.makeResourceId(resourceName, true));
    }

    private static String findDescriptionLabel(String resourceIdentifier, String resourceName) throws Exception {
        return Labels.loadProperties(resourceIdentifier).getProperty(Labels.makeResourceId(resourceName, false));
    }

    private static String makeResourceId(String resourceName, Boolean titleType) {
        return resourceName + "." + (titleType != false ? "title" : "description");
    }

    private static Properties loadProperties(String filename) throws IOException {
        URL url = Resources.getResource((String)filename);
        Properties props = new Properties();
        ByteSource byteSource = Resources.asByteSource((URL)url);
        InputStream inputStream = null;
        inputStream = byteSource.openBufferedStream();
        props.load(inputStream);
        return props;
    }
}

