/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.helpers;

import org.streampipes.model.output.TransformOperation;
import org.streampipes.model.output.TransformOperationType;
import org.streampipes.sdk.utils.Datatypes;

public class TransformOperations {
    public static TransformOperation staticDatatypeTransformation(String mappingPropertyInternalName, Datatypes targetDatatype) {
        return TransformOperations.staticTransformOperation(TransformOperationType.DATATYPE_TRANSFORMATION, mappingPropertyInternalName, targetDatatype.toString());
    }

    public static TransformOperation dynamicDatatypeTransformation(String mappingPropertyInternalName, String linkedStaticProperty) {
        return TransformOperations.dynamicTransformOperation(TransformOperationType.DATATYPE_TRANSFORMATION, mappingPropertyInternalName, linkedStaticProperty);
    }

    public static TransformOperation staticDomainPropertyTransformation(String mappingPropertyInternalName, String targetValue) {
        return TransformOperations.staticTransformOperation(TransformOperationType.DOMAIN_PROPERTY_TRANSFORMATION, mappingPropertyInternalName, targetValue);
    }

    public static TransformOperation dynamicDomainPropertyTransformation(String mappingPropertyInternalName, String linkedStaticProperty) {
        return TransformOperations.dynamicTransformOperation(TransformOperationType.DOMAIN_PROPERTY_TRANSFORMATION, mappingPropertyInternalName, linkedStaticProperty);
    }

    public static TransformOperation staticRuntimeNameTransformation(String mappingPropertyInternalName, String targetValue) {
        return TransformOperations.staticTransformOperation(TransformOperationType.RUNTIME_NAME_TRANSFORMATION, mappingPropertyInternalName, targetValue);
    }

    public static TransformOperation dynamicRuntimeNameTransformation(String mappingPropertyInternalName, String linkedStaticProperty) {
        return TransformOperations.dynamicTransformOperation(TransformOperationType.RUNTIME_NAME_TRANSFORMATION, mappingPropertyInternalName, linkedStaticProperty);
    }

    public static TransformOperation staticMeasurementUnitTransformation(String mappingPropertyInternalName, String targetValue) {
        return TransformOperations.staticTransformOperation(TransformOperationType.MEASUREMENT_UNIT_TRANSFORMATION, mappingPropertyInternalName, targetValue);
    }

    public static TransformOperation dynamicMeasurementUnitTransformation(String mappingPropertyInternalName, String sourceStaticPropertyInternalName) {
        return TransformOperations.dynamicTransformOperation(TransformOperationType.MEASUREMENT_UNIT_TRANSFORMATION, mappingPropertyInternalName, sourceStaticPropertyInternalName);
    }

    private static TransformOperation staticTransformOperation(TransformOperationType transformationScope, String mappingPropertyInternalName, String targetValue) {
        TransformOperation to = TransformOperations.prepareTransformOperation(transformationScope.name(), mappingPropertyInternalName);
        to.setTargetValue(targetValue);
        return to;
    }

    private static TransformOperation dynamicTransformOperation(TransformOperationType transformationScope, String mappingPropertyInternalName, String sourceStaticPropertyInternalName) {
        TransformOperation to = TransformOperations.prepareTransformOperation(transformationScope.name(), mappingPropertyInternalName);
        to.setSourceStaticProperty(sourceStaticPropertyInternalName);
        return to;
    }

    private static TransformOperation prepareTransformOperation(String transformationScope, String mappingPropertyInternalName) {
        return new TransformOperation(transformationScope, mappingPropertyInternalName);
    }
}

