/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.model.schema.PropertyScope;
import org.streampipes.model.staticproperty.MappingProperty;
import org.streampipes.model.staticproperty.MappingPropertyNary;
import org.streampipes.model.staticproperty.MappingPropertyUnary;
import org.streampipes.sdk.helpers.CollectedStreamRequirements;
import org.streampipes.sdk.helpers.Label;

public class StreamRequirementsBuilder {
    private List<EventProperty> eventProperties = new ArrayList<EventProperty>();
    private List<MappingProperty> mappingProperties = new ArrayList<MappingProperty>();

    public static StreamRequirementsBuilder create() {
        return new StreamRequirementsBuilder();
    }

    private StreamRequirementsBuilder() {
    }

    public StreamRequirementsBuilder requiredProperty(EventProperty propertyRequirement) {
        this.eventProperties.add(propertyRequirement);
        return this;
    }

    public StreamRequirementsBuilder requiredPropertyWithUnaryMapping(EventProperty propertyRequirement, Label label, PropertyScope propertyScope) {
        propertyRequirement.setRuntimeName(label.getInternalId());
        this.eventProperties.add(propertyRequirement);
        MappingPropertyUnary mp = new MappingPropertyUnary(label.getInternalId(), label.getInternalId(), label.getLabel(), label.getDescription());
        mp.setPropertyScope(propertyScope.name());
        this.mappingProperties.add((MappingProperty)mp);
        return this;
    }

    public StreamRequirementsBuilder requiredPropertyWithNaryMapping(EventProperty propertyRequirement, Label label, PropertyScope propertyScope) {
        propertyRequirement.setRuntimeName(label.getInternalId());
        this.eventProperties.add(propertyRequirement);
        MappingPropertyNary mp = new MappingPropertyNary(label.getInternalId(), label.getInternalId(), label.getLabel(), label.getDescription());
        mp.setPropertyScope(propertyScope.name());
        this.mappingProperties.add((MappingProperty)mp);
        return this;
    }

    public CollectedStreamRequirements build() {
        SpDataStream stream = new SpDataStream();
        stream.setEventSchema(new EventSchema(this.eventProperties));
        return new CollectedStreamRequirements(stream, this.mappingProperties);
    }
}

