/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.extractor;

import com.github.drapostolos.typeparser.TypeParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.client.fluent.Request;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.config.backend.BackendConfig;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.schema.PropertyScope;
import org.streampipes.model.staticproperty.AnyStaticProperty;
import org.streampipes.model.staticproperty.CollectionStaticProperty;
import org.streampipes.model.staticproperty.DomainStaticProperty;
import org.streampipes.model.staticproperty.FileStaticProperty;
import org.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.streampipes.model.staticproperty.MappingPropertyNary;
import org.streampipes.model.staticproperty.MappingPropertyUnary;
import org.streampipes.model.staticproperty.OneOfStaticProperty;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.staticproperty.SecretStaticProperty;
import org.streampipes.model.staticproperty.SelectionStaticProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.StaticPropertyAlternative;
import org.streampipes.model.staticproperty.StaticPropertyAlternatives;
import org.streampipes.model.staticproperty.StaticPropertyGroup;
import org.streampipes.model.staticproperty.StaticPropertyType;
import org.streampipes.model.staticproperty.SupportedProperty;

public abstract class AbstractParameterExtractor<T extends InvocableStreamPipesEntity> {
    protected T sepaElement;
    private TypeParser typeParser;

    public AbstractParameterExtractor(T sepaElement) {
        this.sepaElement = sepaElement;
        this.typeParser = TypeParser.newBuilder().build();
    }

    public String measurementUnit(String runtimeName, Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventSchema().getEventProperties().stream().filter(ep -> ep.getRuntimeName().equals(runtimeName)).map(ep -> (EventPropertyPrimitive)ep).findFirst().get().getMeasurementUnit().toString();
    }

    public String inputTopic(Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventGrounding().getTransportProtocol().getTopicDefinition().getActualTopicName();
    }

    public <V> V singleValueParameter(String internalName, Class<V> targetClass) {
        return (V)this.typeParser.parse(this.getStaticPropertyByName(internalName, FreeTextStaticProperty.class).getValue(), targetClass);
    }

    public String secretValue(String internalName) {
        return this.getStaticPropertyByName(internalName, SecretStaticProperty.class).getValue();
    }

    public String fileContentsAsString(String internalName) throws IOException {
        String filename = this.getStaticPropertyByName(internalName, FileStaticProperty.class).getLocationPath();
        return Request.Get((String)this.makeFileRequestPath(filename)).execute().returnContent().asString();
    }

    public byte[] fileContentsAsByteArray(String internalName) throws IOException {
        String filename = this.getStaticPropertyByName(internalName, FileStaticProperty.class).getLocationPath();
        return Request.Get((String)this.makeFileRequestPath(filename)).execute().returnContent().asBytes();
    }

    private String makeFileRequestPath(String filename) {
        return BackendConfig.INSTANCE.getBackendUrl() + "/streampipes-backend/api/v2/noauth/files/" + filename;
    }

    private <V, T extends SelectionStaticProperty> V selectedSingleValue(String internalName, Class<V> targetClass, Class<T> oneOfStaticProperty) {
        return (V)this.typeParser.parse(((SelectionStaticProperty)this.getStaticPropertyByName(internalName, oneOfStaticProperty)).getOptions().stream().filter(Option::isSelected).findFirst().get().getName(), targetClass);
    }

    @Deprecated
    public <V> V selectedSingleValueFromRemote(String internalName, Class<V> targetClass) {
        return this.selectedSingleValue(internalName, targetClass);
    }

    public <V> V selectedSingleValue(String internalName, Class<V> targetClass) {
        return this.selectedSingleValue(internalName, targetClass, OneOfStaticProperty.class);
    }

    public <V> V selectedSingleValueInternalName(String internalName, Class<V> targetClass) {
        return (V)this.typeParser.parse(this.getStaticPropertyByName(internalName, OneOfStaticProperty.class).getOptions().stream().filter(Option::isSelected).findFirst().get().getInternalName(), targetClass);
    }

    public <V> List<V> singleValueParameterFromCollection(String internalName, Class<V> targetClass) {
        CollectionStaticProperty collection = this.getStaticPropertyByName(internalName, CollectionStaticProperty.class);
        return collection.getMembers().stream().map(sp -> (FreeTextStaticProperty)sp).map(FreeTextStaticProperty::getValue).map(v -> this.typeParser.parse(v, targetClass)).collect(Collectors.toList());
    }

    public <V> List<V> selectedMultiValues(String internalName, Class<V> targetClass) {
        return this.getStaticPropertyByName(internalName, AnyStaticProperty.class).getOptions().stream().filter(Option::isSelected).map(Option::getName).map(o -> this.typeParser.parse(o, targetClass)).collect(Collectors.toList());
    }

    private <S extends StaticProperty> S getStaticPropertyByName(String internalName, Class<S> spType) {
        return (S)((StaticProperty)spType.cast(this.getStaticPropertyByName(internalName)));
    }

    private StaticProperty getStaticPropertyByName(String name) {
        return this.getStaticPropertyByName(this.sepaElement.getStaticProperties(), name);
    }

    private StaticProperty getStaticPropertyByName(List<StaticProperty> staticProperties, String name) {
        for (StaticProperty p : staticProperties) {
            StaticProperty tmp;
            if (p.getInternalName().equals(name)) {
                return p;
            }
            if (p.getStaticPropertyType() == StaticPropertyType.StaticPropertyGroup) {
                return this.getStaticPropertyByName(((StaticPropertyGroup)p).getStaticProperties(), name);
            }
            if (p.getStaticPropertyType() != StaticPropertyType.StaticPropertyAlternatives || (tmp = this.getStaticPropertyFromSelectedAlternative((StaticPropertyAlternatives)p)) == null || (tmp = this.getStaticPropertyByName(Collections.singletonList(tmp), name)) == null || !tmp.getInternalName().equals(name)) continue;
            return tmp;
        }
        return null;
    }

    private StaticProperty getStaticPropertyFromSelectedAlternative(StaticPropertyAlternatives sp) {
        return sp.getAlternatives().stream().filter(StaticPropertyAlternative::getSelected).findFirst().get().getStaticProperty();
    }

    public String mappingPropertyValue(String staticPropertyName) {
        return this.getPropertySelectorFromUnaryMapping(staticPropertyName);
    }

    public List<String> mappingPropertyValues(String staticPropertyName) {
        return this.getPropertySelectorsFromNaryMapping(staticPropertyName);
    }

    public String propertyDatatype(String runtimeName) {
        ArrayList eventProperties = new ArrayList();
        for (SpDataStream is : this.sepaElement.getInputStreams()) {
            eventProperties.addAll(is.getEventSchema().getEventProperties());
        }
        Optional<EventProperty> matchedProperty = eventProperties.stream().filter(ep -> ep.getRuntimeName().equals(runtimeName)).findFirst();
        if (matchedProperty.isPresent()) {
            EventProperty listProperty;
            EventProperty p = matchedProperty.get();
            if (p instanceof EventPropertyPrimitive) {
                return ((EventPropertyPrimitive)p).getRuntimeType();
            }
            if (p instanceof EventPropertyList && (listProperty = ((EventPropertyList)p).getEventProperty()) instanceof EventPropertyPrimitive) {
                return ((EventPropertyPrimitive)listProperty).getRuntimeType();
            }
        }
        return null;
    }

    public <V> V supportedOntologyPropertyValue(String domainPropertyInternalId, String propertyId, Class<V> targetClass) {
        DomainStaticProperty dsp = this.getStaticPropertyByName(domainPropertyInternalId, DomainStaticProperty.class);
        return (V)this.typeParser.parse(dsp.getSupportedProperties().stream().filter(sp -> sp.getPropertyId().equals(propertyId)).findFirst().map(SupportedProperty::getValue).get(), targetClass);
    }

    public List<EventProperty> getEventPropertiesBySelector(List<String> selectors) throws SpRuntimeException {
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        for (String selector : selectors) {
            properties.add(this.getEventPropertyBySelector(selector));
        }
        return properties;
    }

    public EventProperty getEventPropertyBySelector(String selector) throws SpRuntimeException {
        SpDataStream input = this.getStreamBySelector(selector);
        List<EventProperty> matchedProperties = this.getEventProperty(selector, this.getStreamSelector(selector), input.getEventSchema().getEventProperties());
        if (matchedProperties.size() > 0) {
            return matchedProperties.get(0);
        }
        throw new SpRuntimeException("Could not find property with selector " + selector);
    }

    public String getEventPropertyTypeBySelector(String selector) throws SpRuntimeException {
        EventProperty eventProperty = this.getEventPropertyBySelector(selector);
        if (eventProperty instanceof EventPropertyPrimitive) {
            return ((EventPropertyPrimitive)eventProperty).getRuntimeType();
        }
        throw new SpRuntimeException("Property with selector " + selector + " is not an EventPropertyPrimitive");
    }

    private List<EventProperty> getEventProperty(String selector, String currentPointer, List<EventProperty> properties) {
        for (EventProperty property : properties) {
            if (this.makePropertyWithSelector(currentPointer, property.getRuntimeName()).equals(selector)) {
                return Collections.singletonList(property);
            }
            if (!EventPropertyNested.class.isInstance(property)) continue;
            return this.getEventProperty(selector, this.makePropertyWithSelector(currentPointer, property.getRuntimeName()), ((EventPropertyNested)property).getEventProperties());
        }
        return Collections.emptyList();
    }

    private String makePropertyWithSelector(String currentPointer, String runtimeName) {
        return currentPointer + "::" + runtimeName;
    }

    private SpDataStream getStreamBySelector(String selector) {
        String streamId = this.getStreamSelector(selector).substring(1);
        return (SpDataStream)this.sepaElement.getInputStreams().get(Integer.parseInt(streamId));
    }

    private String getStreamSelector(String selector) {
        return selector.split("::")[0];
    }

    public List<EventProperty> getNoneInputStreamEventPropertySubset(List<String> propertySelectors) {
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        for (SpDataStream stream : this.sepaElement.getInputStreams()) {
            properties.addAll(this.getNoneInputStreamEventPropertySubset(propertySelectors, this.sepaElement.getInputStreams().indexOf(stream)));
        }
        return properties;
    }

    private List<EventProperty> getNoneInputStreamEventPropertySubset(List<String> propertySelectors, Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventSchema().getEventProperties().stream().filter(ep -> propertySelectors.stream().noneMatch(ps -> this.getBySelector(ep.getRuntimeName(), streamIndex).equals(ps))).collect(Collectors.toList());
    }

    public List<EventProperty> getInputStreamEventPropertySubset(List<String> propertySelectors) {
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        for (SpDataStream stream : this.sepaElement.getInputStreams()) {
            properties.addAll(this.getInputStreamEventPropertySubset(propertySelectors, this.sepaElement.getInputStreams().indexOf(stream)));
        }
        return properties;
    }

    private List<EventProperty> getInputStreamEventPropertySubset(List<String> propertySelectors, Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventSchema().getEventProperties().stream().filter(ep -> propertySelectors.stream().anyMatch(ps -> this.getBySelector(ep.getRuntimeName(), streamIndex).equals(ps))).collect(Collectors.toList());
    }

    private String getBySelector(String runtimeName, Integer streamIndex) {
        return this.getStreamIndex(streamIndex) + "::" + runtimeName;
    }

    private String getStreamIndex(Integer streamIndex) {
        return "s" + streamIndex;
    }

    private String getPropertySelectorFromUnaryMapping(String staticPropertyName) {
        Optional<MappingPropertyUnary> property = this.sepaElement.getStaticProperties().stream().filter(p -> p instanceof MappingPropertyUnary).map(p -> (MappingPropertyUnary)p).filter(p -> p.getInternalName().equals(staticPropertyName)).findFirst();
        return property.map(MappingPropertyUnary::getSelectedProperty).orElse(null);
    }

    private List<String> getPropertySelectorsFromNaryMapping(String staticPropertyName) {
        Optional<MappingPropertyNary> property = this.sepaElement.getStaticProperties().stream().filter(p -> p instanceof MappingPropertyNary).map(p -> (MappingPropertyNary)p).filter(p -> p.getInternalName().equals(staticPropertyName)).findFirst();
        return property.map(MappingPropertyNary::getSelectedProperties).orElse(new ArrayList());
    }

    public String selectedAlternativeInternalId(String alternativesInternalId) {
        StaticPropertyAlternatives alternatives = this.getStaticPropertyByName(alternativesInternalId, StaticPropertyAlternatives.class);
        return alternatives.getAlternatives().stream().filter(StaticPropertyAlternative::getSelected).map(StaticProperty::getInternalName).findFirst().get();
    }

    public List<String> getEventPropertiesRuntimeNamesByScope(PropertyScope scope) {
        ArrayList<String> propertiesSelector = new ArrayList<String>();
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        for (SpDataStream stream : this.sepaElement.getInputStreams()) {
            int streamIndex = this.sepaElement.getInputStreams().indexOf(stream);
            this.getEventPropertiesByScope(scope, streamIndex).stream().forEach(ep -> propertiesSelector.add(ep.getRuntimeName()));
            properties.addAll(this.getEventPropertiesByScope(scope, this.sepaElement.getInputStreams().indexOf(stream)));
        }
        return propertiesSelector;
    }

    public List<String> getEventPropertiesSelectorByScope(PropertyScope scope) {
        ArrayList<String> propertiesSelector = new ArrayList<String>();
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        for (SpDataStream stream : this.sepaElement.getInputStreams()) {
            int streamIndex = this.sepaElement.getInputStreams().indexOf(stream);
            this.getEventPropertiesByScope(scope, streamIndex).stream().forEach(ep -> propertiesSelector.add(this.getBySelector(ep.getRuntimeName(), streamIndex)));
            properties.addAll(this.getEventPropertiesByScope(scope, this.sepaElement.getInputStreams().indexOf(stream)));
        }
        return propertiesSelector;
    }

    public List<EventProperty> getEventPropertiesByScope(PropertyScope scope) {
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        for (SpDataStream stream : this.sepaElement.getInputStreams()) {
            properties.addAll(this.getEventPropertiesByScope(scope, this.sepaElement.getInputStreams().indexOf(stream)));
        }
        return properties;
    }

    private List<EventProperty> getEventPropertiesByScope(PropertyScope scope, Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventSchema().getEventProperties().stream().filter(ep -> ep.getPropertyScope() != null && ep.getPropertyScope().equals(scope.name())).collect(Collectors.toList());
    }
}

