/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.serializers.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import org.streampipes.model.DataProcessorType;
import org.streampipes.model.DataSinkType;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.grounding.TopicDefinition;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.quality.EventPropertyQualityDefinition;
import org.streampipes.model.quality.EventStreamQualityDefinition;
import org.streampipes.model.quality.Frequency;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.ValueSpecification;
import org.streampipes.model.staticproperty.MappingProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.serializers.json.EcTypeAdapter;
import org.streampipes.serializers.json.EpaTypeAdapter;
import org.streampipes.serializers.json.JsonLdSerializer;
import org.streampipes.serializers.json.RuntimeTypeAdapterFactory;
import org.streampipes.serializers.json.UriSerializer;

public class GsonSerializer {
    public static Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(EventProperty.class, new JsonLdSerializer());
        builder.registerTypeAdapter(StaticProperty.class, new JsonLdSerializer());
        builder.registerTypeAdapter(OutputStrategy.class, new JsonLdSerializer());
        builder.registerTypeAdapter(TransportProtocol.class, new JsonLdSerializer());
        builder.registerTypeAdapter(ValueSpecification.class, new JsonLdSerializer());
        builder.registerTypeAdapter(TopicDefinition.class, new JsonLdSerializer());
        builder.registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(SpDataStream.class, "sourceType").registerSubtype(SpDataSet.class, "org.streampipes.model.SpDataSet").registerSubtype(SpDataStream.class, "org.streampipes.model.SpDataStream"));
        builder.setPrettyPrinting();
        return builder.create();
    }

    public static GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(EventProperty.class, new JsonLdSerializer());
        builder.registerTypeAdapter(StaticProperty.class, new JsonLdSerializer());
        builder.registerTypeAdapter(OutputStrategy.class, new JsonLdSerializer());
        builder.registerTypeAdapter(TransportProtocol.class, new JsonLdSerializer());
        builder.registerTypeAdapter(MappingProperty.class, new JsonLdSerializer());
        builder.registerTypeAdapter(ValueSpecification.class, new JsonLdSerializer());
        builder.registerTypeAdapter(DataSinkType.class, (Object)new EcTypeAdapter());
        builder.registerTypeAdapter(DataProcessorType.class, (Object)new EpaTypeAdapter());
        builder.registerTypeAdapter(URI.class, (Object)new UriSerializer());
        builder.registerTypeAdapter(Frequency.class, new JsonLdSerializer());
        builder.registerTypeAdapter(EventPropertyQualityDefinition.class, new JsonLdSerializer());
        builder.registerTypeAdapter(EventStreamQualityDefinition.class, new JsonLdSerializer());
        builder.registerTypeAdapter(TopicDefinition.class, new JsonLdSerializer());
        builder.registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(SpDataStream.class, "sourceType").registerSubtype(SpDataSet.class, "org.streampipes.model.SpDataSet").registerSubtype(SpDataStream.class, "org.streampipes.model.SpDataStream"));
        builder.setPrettyPrinting();
        return builder;
    }

    public static Gson getGson(boolean keepIds) {
        return keepIds ? GsonSerializer.getGsonWithIds() : GsonSerializer.getGsonWithoutIds();
    }

    public static Gson getGsonWithIds() {
        return GsonSerializer.getGsonBuilder().create();
    }

    public static Gson getGsonWithoutIds() {
        GsonBuilder builder = GsonSerializer.getGsonBuilder();
        builder.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                if (f.getName().equals("elementName")) {
                    return true;
                }
                return f.getName().equals("elementId");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        });
        return builder.create();
    }
}

