/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.serializers.jsonld;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.streampipes.empire.core.empire.annotation.InvalidRdfException;
import org.streampipes.empire.pinto.MappingOptions;
import org.streampipes.empire.pinto.RDFMapper;
import org.streampipes.empire.pinto.UriSerializationStrategy;
import org.streampipes.serializers.jsonld.CustomAnnotationProvider;
import org.streampipes.serializers.jsonld.RdfTransformer;

public class JsonLdTransformer
implements RdfTransformer {
    private static final List<String> standardRootElements = Arrays.asList("https://streampipes.org/vocabulary/v1/DataProcessorDescription", "https://streampipes.org/vocabulary/v1/DataSourceDescription", "https://streampipes.org/vocabulary/v1/DataSinkDescription", "https://streampipes.org/vocabulary/v1/DataProcessorInvocation", "https://streampipes.org/vocabulary/v1/DataSinkInvocation", "https://streampipes.org/vocabulary/v1/AdapterDescriptionList", "https://streampipes.org/vocabulary/v1/FromatDescriptionList", "https://streampipes.org/vocabulary/v1/ProtocolDescriptionList", "https://streampipes.org/vocabulary/v1/GuessSchema", "https://streampipes.org/vocabulary/v1/DomainPropertyProbabilityList", "https://streampipes.org/vocabulary/v1/AdapterDescription");
    private List<String> selectedRootElements;

    public JsonLdTransformer() {
        this.selectedRootElements = standardRootElements;
    }

    public JsonLdTransformer(String rootElement) {
        this.selectedRootElements = Collections.singletonList(rootElement);
    }

    @Override
    public <T> Graph toJsonLd(T element) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, ClassNotFoundException, InvalidRdfException {
        return this.makeRdfMapper().writeValue(element);
    }

    @Override
    public <T> T fromJsonLd(String json, Class<T> destination) throws RDFParseException, UnsupportedRDFormatException, IOException, RepositoryException {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        Model statements = Rio.parse((InputStream)stream, (String)"", (RDFFormat)RDFFormat.JSONLD, (Resource[])new Resource[0]);
        return (T)this.makeRdfMapper().readValue(statements, destination, this.getResource(statements));
    }

    private RDFMapper makeRdfMapper() {
        return RDFMapper.builder().set(MappingOptions.IGNORE_PROPERTIES_WITHOUT_ANNOTATION, (Object)true).set(MappingOptions.REQUIRE_IDS, (Object)true).set(MappingOptions.USE_PROVIDED_CLASSES, (Object)new CustomAnnotationProvider()).set(MappingOptions.URI_SERIALIZATION_STRATEGY, (Object)UriSerializationStrategy.INSTANCE).set(MappingOptions.REGISTER_ADDITIONAL_NAMESPACES, Arrays.asList(new SimpleNamespace("sp", "https://streampipes.org/vocabulary/v1/"), new SimpleNamespace("so", "http://schema.org/"))).build();
    }

    private Resource getResource(Model model) {
        for (Statement s : model) {
            if (!s.getPredicate().equals((Object)RDF.TYPE) || !this.isRootElement(s)) continue;
            return s.getSubject();
        }
        return null;
    }

    private boolean isRootElement(Statement s) {
        return this.selectedRootElements.stream().anyMatch(rootElement -> this.hasObject(s, (String)rootElement));
    }

    private boolean hasObject(Statement statement, String voc) {
        return statement.getObject().stringValue().equals(voc);
    }
}

