/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.serializers.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Type;
import org.streampipes.model.connect.rules.TransformationRuleDescription;
import org.streampipes.serializers.json.GsonSerializer;

public class TransformationRuleSerializer
implements JsonSerializer<TransformationRuleDescription>,
JsonDeserializer<TransformationRuleDescription> {
    public TransformationRuleDescription deserialize(JsonElement json, Type typeInfo, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.get("type").getAsString();
        JsonElement element = jsonObject.get("properties");
        JsonObject tmp = element.getAsJsonObject();
        tmp.addProperty("_id", jsonObject.get("_id").getAsString());
        tmp.addProperty("_rev", jsonObject.get("_rev").getAsString());
        try {
            return (TransformationRuleDescription)GsonSerializer.getGson().fromJson(element, Class.forName(type));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
        }
    }

    public JsonElement serialize(TransformationRuleDescription src, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        try {
            result.add("type", (JsonElement)new JsonPrimitive(src.getClass().getCanonicalName()));
            result.add("properties", GsonSerializer.getGson().toJsonTree((Object)src));
        }
        catch (MalformedParameterizedTypeException e) {
            e.printStackTrace();
        }
        return result;
    }
}

