/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.serializers.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdSerializer<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLdSerializer.class);

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.get("type").getAsString();
        JsonElement element = jsonObject.get("properties");
        try {
            return (T)context.deserialize(element, Class.forName(type));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
        }
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        try {
            result.add("type", (JsonElement)new JsonPrimitive(src.getClass().getCanonicalName()));
            result.add("properties", context.serialize(src, src.getClass()));
        }
        catch (MalformedParameterizedTypeException e) {
            LOG.error("Could not serialize class {}", (Object)src.getClass().getCanonicalName(), (Object)e);
        }
        return result;
    }
}

