/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.serializers.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ProcessingElementSerializer<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.get("sourceClass").getAsString();
        try {
            return (T)context.deserialize((JsonElement)jsonObject, Class.forName(type));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
        }
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement result = context.serialize(src, src.getClass());
        if (result.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)result;
            jsonObject.add("sourceClass", (JsonElement)new JsonPrimitive(src.getClass().getCanonicalName()));
        }
        return result;
    }
}

