/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage.rdf4j.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.streampipes.model.client.ontology.Concept;
import org.streampipes.model.client.ontology.ElementHeader;
import org.streampipes.model.client.ontology.Instance;
import org.streampipes.model.client.ontology.Namespace;
import org.streampipes.model.client.ontology.NodeType;
import org.streampipes.model.client.ontology.OntologyNode;
import org.streampipes.model.client.ontology.OntologyQuery;
import org.streampipes.model.client.ontology.OntologyQueryItem;
import org.streampipes.model.client.ontology.OntologyQueryResponse;
import org.streampipes.model.client.ontology.Property;
import org.streampipes.model.client.ontology.Resource;
import org.streampipes.storage.api.IBackgroundKnowledgeStorage;
import org.streampipes.storage.rdf4j.filter.BackgroundKnowledgeFilter;
import org.streampipes.storage.rdf4j.ontology.ClassHierarchyExecutor;
import org.streampipes.storage.rdf4j.ontology.ConceptUpdateExecutor;
import org.streampipes.storage.rdf4j.ontology.InstanceUpdateExecutor;
import org.streampipes.storage.rdf4j.ontology.PropertyUpdateExecutor;
import org.streampipes.storage.rdf4j.ontology.QueryExecutor;
import org.streampipes.storage.rdf4j.ontology.RangeQueryExecutor;
import org.streampipes.storage.rdf4j.sparql.QueryBuilder;
import org.streampipes.storage.rdf4j.util.BackgroundKnowledgeUtils;

public class BackgroundKnowledgeStorageImpl
implements IBackgroundKnowledgeStorage {
    Repository repo;

    public BackgroundKnowledgeStorageImpl(Repository repo) {
        this.repo = repo;
    }

    public List<OntologyNode> getClassHierarchy() throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        return new ClassHierarchyExecutor(this.repo).getClassHierarchy();
    }

    public List<OntologyNode> getPropertyHierarchy() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        ArrayList<OntologyNode> ontologyNodes = new ArrayList<OntologyNode>();
        String queryString = QueryBuilder.getEventProperties();
        TupleQueryResult result = this.getQueryResult(queryString);
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            Value valueOfX = bindingSet.getValue("result");
            Optional<Namespace> ns = this.getNamespace(valueOfX.toString());
            if (ns.isPresent()) {
                ontologyNodes.add(new OntologyNode(valueOfX.toString(), valueOfX.toString().replace(ns.get().getNamespaceId(), ns.get().getPrefix() + ":"), ns.get().getPrefix(), ns.get().getNamespaceId(), NodeType.PROPERTY));
                continue;
            }
            ontologyNodes.add(new OntologyNode(valueOfX.toString(), valueOfX.toString(), NodeType.PROPERTY));
        }
        return BackgroundKnowledgeFilter.propertiesFilter(ontologyNodes, true);
    }

    private Property getProperty(String propertyId, String instanceId) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        ElementHeader header = null;
        Property property = null;
        RangeQueryExecutor rangeExecutor = null;
        String label = "";
        String description = "";
        String range = "";
        ArrayList<String> rangeTypes = new ArrayList<String>();
        String queryString = QueryBuilder.getProperty(propertyId);
        TupleQueryResult result = this.getQueryResult(queryString);
        Optional<Namespace> nsOpt = this.getNamespace(propertyId);
        if (nsOpt.isPresent()) {
            Namespace ns = nsOpt.get();
            header = new ElementHeader(propertyId, propertyId.replace(ns.getNamespaceId(), ns.getPrefix() + ":"), ns.getPrefix(), ns.getNamespaceId());
        } else {
            header = new ElementHeader(propertyId, propertyId);
        }
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            Value labelField = bindingSet.getValue("label");
            Value descriptionField = bindingSet.getValue("description");
            range = bindingSet.getValue("range").stringValue();
            rangeTypes.add(bindingSet.getValue("rangeType").stringValue());
            if (labelField != null) {
                label = labelField.stringValue();
            }
            if (descriptionField == null) continue;
            description = descriptionField.stringValue();
        }
        rangeExecutor = instanceId == null ? new RangeQueryExecutor(this.repo, propertyId, range, rangeTypes) : new RangeQueryExecutor(this.repo, propertyId, range, rangeTypes, instanceId);
        property = new Property(header, label, description, rangeExecutor.getRange());
        property.setRangeDefined(range != null && !range.equals(""));
        return property;
    }

    public Property getProperty(String propertyId) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        return this.getProperty(propertyId, null);
    }

    public Concept getConcept(String conceptId) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQueryResult result = this.getQueryResult(QueryBuilder.getTypeDetails(conceptId));
        Concept concept = new Concept();
        ElementHeader header = null;
        ArrayList<Property> properties = new ArrayList<Property>();
        int idx = 0;
        Optional<Namespace> nsOpt = this.getNamespace(conceptId);
        if (nsOpt.isPresent()) {
            Namespace ns = nsOpt.get();
            header = new ElementHeader(conceptId, conceptId.replace(ns.getNamespaceId(), ns.getPrefix() + ":"), ns.getPrefix(), ns.getNamespaceId());
        } else {
            header = new ElementHeader(conceptId, conceptId);
        }
        concept.setElementHeader(header);
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            if (idx == 0) {
                Value label = bindingSet.getValue("label");
                Value description = bindingSet.getValue("description");
                if (label != null) {
                    concept.setRdfsLabel(label.stringValue());
                }
                if (description != null) {
                    concept.setRdfsDescription(description.stringValue());
                }
            }
            Value domainPropertyId = bindingSet.getValue("domainPropertyId");
            Property property = this.getProperty(domainPropertyId.stringValue());
            properties.add(property);
            ++idx;
        }
        concept.setDomainProperties(BackgroundKnowledgeUtils.filterDuplicates(properties));
        return concept;
    }

    public boolean updateProperty(Property property) {
        PropertyUpdateExecutor propertyUpdateExecutor = new PropertyUpdateExecutor(this.repo, property);
        try {
            propertyUpdateExecutor.deleteExistingTriples();
            propertyUpdateExecutor.addNewTriples();
            return true;
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Namespace> getNamespaces() throws RepositoryException {
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        RepositoryResult namespaces = this.repo.getConnection().getNamespaces();
        while (namespaces.hasNext()) {
            org.eclipse.rdf4j.model.Namespace ns = (org.eclipse.rdf4j.model.Namespace)namespaces.next();
            result.add(new Namespace(ns.getPrefix(), ns.getName()));
        }
        return result;
    }

    private Optional<Namespace> getNamespace(String propertyId) {
        return BackgroundKnowledgeUtils.getNamespace(propertyId);
    }

    private TupleQueryResult getQueryResult(String queryString) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        return new QueryExecutor(this.repo).executeQuery(queryString);
    }

    public boolean addNamespace(Namespace namespace) {
        try {
            RepositoryConnection conn = this.repo.getConnection();
            conn.setNamespace(namespace.getPrefix(), namespace.getNamespaceId());
            conn.close();
            return true;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteNamespace(String prefix) {
        try {
            RepositoryConnection conn = this.repo.getConnection();
            conn.removeNamespace(prefix);
            conn.close();
            return true;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addProperty(Resource resource) {
        return this.addResource(resource, (URI)RDF.PROPERTY);
    }

    public boolean addConcept(Resource resource) {
        return this.addResource(resource, (URI)RDFS.CLASS);
    }

    public boolean addIndividual(Resource resource) {
        try {
            RepositoryConnection conn = this.repo.getConnection();
            ValueFactory factory = conn.getValueFactory();
            String elementName = resource.getElementName().replaceAll(" ", "_");
            Statement st = resource.getInstanceOf() != null ? factory.createStatement((org.eclipse.rdf4j.model.Resource)factory.createURI(resource.getNamespace() + elementName), RDF.TYPE, (Value)factory.createURI(resource.getInstanceOf())) : factory.createStatement((org.eclipse.rdf4j.model.Resource)factory.createURI(resource.getNamespace() + elementName), RDF.TYPE, (Value)RDFS.RESOURCE);
            conn.add(st, new org.eclipse.rdf4j.model.Resource[0]);
            conn.close();
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private boolean addResource(Resource resource, URI object) {
        try {
            RepositoryConnection conn = this.repo.getConnection();
            ValueFactory factory = conn.getValueFactory();
            String elementName = resource.getElementName().replaceAll(" ", "_");
            Statement st = factory.createStatement((org.eclipse.rdf4j.model.Resource)factory.createURI(resource.getNamespace() + elementName), RDF.TYPE, (Value)object);
            conn.add(st, new org.eclipse.rdf4j.model.Resource[0]);
            conn.close();
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean updateConcept(Concept concept) {
        ConceptUpdateExecutor conceptUpdateExecutor = new ConceptUpdateExecutor(this.repo, concept);
        try {
            conceptUpdateExecutor.deleteExistingTriples();
            conceptUpdateExecutor.addNewTriples();
            return true;
        }
        catch (MalformedQueryException | QueryEvaluationException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Instance getInstance(String instanceId) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQueryResult result = this.getQueryResult(QueryBuilder.getInstanceDetails(instanceId));
        Instance instance = new Instance();
        ElementHeader header = null;
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<String> instanceProperties = new ArrayList<String>();
        int idx = 0;
        Optional<Namespace> nsOpt = this.getNamespace(instanceId);
        if (nsOpt.isPresent()) {
            Namespace ns = nsOpt.get();
            header = new ElementHeader(instanceId, instanceId.replace(ns.getNamespaceId(), ns.getPrefix() + ":"), ns.getPrefix(), ns.getNamespaceId());
        } else {
            header = new ElementHeader(instanceId, instanceId);
        }
        instance.setElementHeader(header);
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            if (idx == 0) {
                Value label = bindingSet.getValue("label");
                Value description = bindingSet.getValue("description");
                if (label != null) {
                    instance.setRdfsLabel(label.stringValue());
                }
                if (description != null) {
                    instance.setRdfsDescription(description.stringValue());
                }
            }
            instanceProperties.add(bindingSet.getValue("property").stringValue());
            ++idx;
        }
        for (String propertyId : instanceProperties) {
            Property p = this.getProperty(propertyId, instanceId);
            properties.add(p);
        }
        List<String> rdfTypes = this.getRdfTypes(instanceId);
        rdfTypes.stream().filter(type -> !BackgroundKnowledgeFilter.omittedPropertyPrefixes.stream().anyMatch(prefix -> type.equals(prefix))).forEach(type -> {
            try {
                Concept concept = this.getConcept((String)type);
                concept.getDomainProperties().stream().filter(dp -> !properties.stream().anyMatch(p -> p.getElementHeader().getId().equals(dp.getElementHeader().getId()))).forEach(dp -> properties.add((Property)dp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        instance.setDomainProperties(BackgroundKnowledgeUtils.filterDuplicates(BackgroundKnowledgeFilter.rdfsFilter(properties, true)));
        return instance;
    }

    private List<String> getRdfTypes(String instanceId) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        ArrayList<String> rdfTypes = new ArrayList<String>();
        TupleQueryResult result = this.getQueryResult(QueryBuilder.getRdfType(instanceId));
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            Value typeOf = bindingSet.getValue("typeOf");
            rdfTypes.add(typeOf.stringValue());
        }
        return rdfTypes;
    }

    public boolean updateInstance(Instance instance) {
        InstanceUpdateExecutor instanceUpdateExecutor = new InstanceUpdateExecutor(this.repo, instance);
        try {
            instanceUpdateExecutor.deleteExistingTriples();
            instanceUpdateExecutor.addNewTriples();
            return true;
        }
        catch (MalformedQueryException | QueryEvaluationException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteResource(String resourceId) {
        String deleteQuery = QueryBuilder.deleteResource(resourceId);
        try {
            RepositoryConnection connection = this.repo.getConnection();
            Update tupleQuery = connection.prepareUpdate(QueryLanguage.SPARQL, deleteQuery);
            tupleQuery.execute();
            connection.close();
            return true;
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public OntologyQuery getOntologyResult(OntologyQuery query) {
        for (OntologyQueryItem item : query.getRequiredProperties()) {
            ArrayList<OntologyQueryResponse> queryResponse = new ArrayList<OntologyQueryResponse>();
            try {
                TupleQueryResult result = this.getQueryResult(QueryBuilder.getPropertyDetails(query.getRequiredClass(), item.getPropertyId(), query.getRequiredProperties()));
                while (result.hasNext()) {
                    BindingSet bindingSet = (BindingSet)result.next();
                    OntologyQueryResponse response = new OntologyQueryResponse();
                    Value label = bindingSet.getValue("label");
                    Value description = bindingSet.getValue("description");
                    Value propertyValue = bindingSet.getValue("propertyValue");
                    if (label != null) {
                        response.setLabel(label.stringValue());
                    }
                    if (description != null) {
                        response.setDescription(description.stringValue());
                    }
                    response.setPropertyValue(propertyValue.stringValue());
                    queryResponse.add(response);
                }
                item.setQueryResponse(queryResponse);
            }
            catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
                e.printStackTrace();
            }
        }
        return query;
    }

    public boolean initialize() {
        try {
            new QueryExecutor(this.repo).executeUpdate(QueryBuilder.addRequiredTriples());
            return true;
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }
}

