/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage.rdf4j.impl;

import com.rits.cloning.Cloner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSourceDescription;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.storage.api.IPipelineElementDescriptionStorage;

public class InMemoryStorage
implements IPipelineElementDescriptionStorage {
    private Map<String, DataSinkDescription> inMemorySECStorage = new HashMap<String, DataSinkDescription>();
    private Map<String, DataSourceDescription> inMemorySEPStorage;
    private Map<String, DataProcessorDescription> inMemorySEPAStorage = new HashMap<String, DataProcessorDescription>();
    private Map<String, SpDataStream> inMemoryEventStreamStorage;
    private IPipelineElementDescriptionStorage sesameStorage;
    private Cloner cloner;

    public InMemoryStorage(IPipelineElementDescriptionStorage sesameStorage) {
        this.inMemorySEPStorage = new HashMap<String, DataSourceDescription>();
        this.inMemoryEventStreamStorage = new HashMap<String, SpDataStream>();
        this.sesameStorage = sesameStorage;
        this.cloner = new Cloner();
        this.init();
    }

    private void init() {
        this.initializeSECStorage();
        this.initializeSEPAStorage();
        this.initializeSEPStorage();
    }

    private void initializeSECStorage() {
        this.inMemorySECStorage.clear();
        List secs = this.sesameStorage.getAllSECs();
        secs.forEach(sec -> this.inMemorySECStorage.put(sec.getElementId().toString(), (DataSinkDescription)sec));
    }

    private void initializeSEPAStorage() {
        this.inMemorySEPAStorage.clear();
        List sepas = this.sesameStorage.getAllSEPAs();
        sepas.forEach(sepa -> this.inMemorySEPAStorage.put(sepa.getElementId().toString(), (DataProcessorDescription)sepa));
    }

    private void initializeSEPStorage() {
        this.inMemorySEPStorage.clear();
        List seps = this.sesameStorage.getAllSEPs();
        seps.forEach(sep -> this.inMemorySEPStorage.put(sep.getElementId(), (DataSourceDescription)sep));
        seps.forEach(sep -> sep.getSpDataStreams().forEach(eventStream -> this.inMemoryEventStreamStorage.put(eventStream.getElementId(), (SpDataStream)eventStream)));
    }

    public boolean storeInvocableSEPAElement(InvocableStreamPipesEntity element) {
        return this.sesameStorage.storeInvocableSEPAElement(element);
    }

    public boolean storeSEP(DataSourceDescription sep) {
        boolean success = this.sesameStorage.storeSEP(sep);
        this.initializeSEPStorage();
        return success;
    }

    public boolean storeSEP(String jsonld) {
        boolean success = this.sesameStorage.storeSEP(jsonld);
        this.initializeSEPStorage();
        return success;
    }

    public boolean storeSEPA(DataProcessorDescription sepa) {
        boolean success = this.sesameStorage.storeSEPA(sepa);
        this.initializeSEPAStorage();
        return success;
    }

    public boolean storeSEPA(String jsonld) {
        boolean success = this.sesameStorage.storeSEP(jsonld);
        this.initializeSEPAStorage();
        return success;
    }

    public DataSourceDescription getSEPById(URI rdfId) {
        return (DataSourceDescription)this.cloner.deepClone((Object)this.inMemorySEPStorage.get(rdfId.toString()));
    }

    public DataSourceDescription getSEPById(String rdfId) throws URISyntaxException {
        return (DataSourceDescription)this.cloner.deepClone((Object)this.inMemorySEPStorage.get(rdfId));
    }

    public DataProcessorDescription getSEPAById(String rdfId) throws URISyntaxException {
        return (DataProcessorDescription)this.cloner.deepClone((Object)this.inMemorySEPAStorage.get(rdfId));
    }

    public DataProcessorDescription getSEPAById(URI rdfId) {
        return (DataProcessorDescription)this.cloner.deepClone((Object)this.inMemorySEPAStorage.get(rdfId.toString()));
    }

    public DataSinkDescription getSECById(String rdfId) throws URISyntaxException {
        return (DataSinkDescription)this.cloner.deepClone((Object)this.inMemorySECStorage.get(rdfId));
    }

    public DataSinkDescription getSECById(URI rdfId) {
        return (DataSinkDescription)this.cloner.deepClone((Object)this.inMemorySECStorage.get(rdfId.toString()));
    }

    public List<DataSourceDescription> getAllSEPs() {
        return new ArrayList<DataSourceDescription>(this.inMemorySEPStorage.values());
    }

    public List<DataProcessorDescription> getAllSEPAs() {
        return new ArrayList<DataProcessorDescription>(this.inMemorySEPAStorage.values());
    }

    public List<DataSourceDescription> getSEPsByDomain(String domain) {
        ArrayList<DataSourceDescription> result = new ArrayList<DataSourceDescription>();
        for (DataSourceDescription sep : this.getAllSEPs()) {
            result.add((DataSourceDescription)this.cloner.deepClone((Object)sep));
        }
        return result;
    }

    public List<DataProcessorDescription> getSEPAsByDomain(String domain) {
        ArrayList<DataProcessorDescription> result = new ArrayList<DataProcessorDescription>();
        for (DataProcessorDescription sepa : this.getAllSEPAs()) {
            result.add((DataProcessorDescription)this.cloner.deepClone((Object)sepa));
        }
        return result;
    }

    public boolean deleteSEP(DataSourceDescription sep) {
        boolean success = this.sesameStorage.deleteSEP(sep);
        this.initializeSEPStorage();
        return success;
    }

    public boolean deleteSEP(String rdfId) {
        boolean success = this.sesameStorage.deleteSEP(rdfId);
        this.initializeSEPStorage();
        return success;
    }

    public boolean deleteSEC(String rdfId) {
        boolean success = this.sesameStorage.deleteSEC(rdfId);
        this.initializeSECStorage();
        return success;
    }

    public boolean deleteSEPA(DataProcessorDescription sepa) {
        boolean success = this.sesameStorage.deleteSEPA(sepa);
        this.initializeSEPAStorage();
        return success;
    }

    public boolean deleteSEPA(String rdfId) {
        boolean success = this.sesameStorage.deleteSEP(rdfId);
        this.initializeSEPAStorage();
        return success;
    }

    public boolean exists(DataSourceDescription sep) {
        return this.inMemorySEPStorage.containsKey(sep.getElementId());
    }

    public boolean exists(DataProcessorDescription sepa) {
        return this.inMemorySEPAStorage.containsKey(sepa.getElementId());
    }

    public boolean existsSepa(String rdfid) {
        return this.inMemoryEventStreamStorage.containsKey(rdfid);
    }

    public boolean update(DataSourceDescription sep) {
        boolean success = this.sesameStorage.update(sep);
        this.initializeSEPStorage();
        return success;
    }

    public boolean update(DataProcessorDescription sepa) {
        boolean success = this.sesameStorage.update(sepa);
        this.initializeSEPAStorage();
        return success;
    }

    public boolean exists(DataSinkDescription sec) {
        return this.inMemorySECStorage.containsKey(sec.getElementId());
    }

    public boolean update(DataSinkDescription sec) {
        boolean success = this.sesameStorage.update(sec);
        this.initializeSECStorage();
        return success;
    }

    public boolean deleteSEC(DataSinkDescription sec) {
        boolean success = this.sesameStorage.deleteSEC(sec);
        this.initializeSECStorage();
        return success;
    }

    public boolean storeSEC(DataSinkDescription sec) {
        boolean success = this.sesameStorage.storeSEC(sec);
        this.initializeSECStorage();
        return success;
    }

    public List<DataSinkDescription> getAllSECs() {
        return new ArrayList<DataSinkDescription>(this.inMemorySECStorage.values());
    }

    public StaticProperty getStaticPropertyById(String rdfId) {
        return this.sesameStorage.getStaticPropertyById(rdfId);
    }

    public SpDataStream getEventStreamById(String rdfId) {
        return this.inMemoryEventStreamStorage.get(rdfId);
    }
}

