/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage.rdf4j.ontology;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.streampipes.model.client.ontology.Namespace;
import org.streampipes.model.client.ontology.NodeType;
import org.streampipes.model.client.ontology.OntologyNode;
import org.streampipes.storage.rdf4j.filter.BackgroundKnowledgeFilter;
import org.streampipes.storage.rdf4j.ontology.QueryExecutor;
import org.streampipes.storage.rdf4j.sparql.QueryBuilder;
import org.streampipes.storage.rdf4j.util.BackgroundKnowledgeUtils;

public class ClassHierarchyExecutor
extends QueryExecutor {
    public ClassHierarchyExecutor(Repository repository) {
        super(repository);
    }

    private List<OntologyNode> getClasses() throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQueryResult result = this.getQueryResult(QueryBuilder.getClasses());
        ArrayList<OntologyNode> classNodes = new ArrayList<OntologyNode>();
        while (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            Value valueOfX = bindingSet.getValue("result");
            classNodes.add(this.makeNode(valueOfX.stringValue(), NodeType.CLASS));
        }
        return BackgroundKnowledgeFilter.classFilter(classNodes, true);
    }

    private String getLabelName(String value) {
        if (value.contains("#")) {
            return value.substring(value.indexOf("#") + 1);
        }
        if (value.contains("/")) {
            return value.substring(value.lastIndexOf("/") + 1);
        }
        return value;
    }

    private TupleQueryResult getQueryResult(String queryString) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        return this.executeQuery(queryString);
    }

    public List<OntologyNode> getClassHierarchy() throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        ArrayList<OntologyNode> classHierarchy = new ArrayList<OntologyNode>();
        for (OntologyNode node : this.getClasses()) {
            ArrayList<OntologyNode> children = new ArrayList<OntologyNode>();
            children.addAll(this.getInstances(node.getId()));
            node.setNodes(children);
            classHierarchy.add(node);
        }
        return classHierarchy;
    }

    private List<OntologyNode> getSubclasses(String nodeUri) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        ArrayList<OntologyNode> result = new ArrayList<OntologyNode>();
        TupleQueryResult queryResult = this.getQueryResult(QueryBuilder.getSubclasses(nodeUri));
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            Value valueOfX = bindingSet.getValue("s");
            result.add(this.makeNode(valueOfX.stringValue(), NodeType.CLASS));
        }
        return result;
    }

    private OntologyNode makeNode(String id, NodeType nodeType) {
        Optional<Namespace> ns = BackgroundKnowledgeUtils.getNamespace(id.toString());
        OntologyNode node = ns.isPresent() ? new OntologyNode(id.toString(), id.toString().replace(ns.get().getNamespaceId(), ns.get().getPrefix() + ":"), ns.get().getPrefix(), ns.get().getNamespaceId(), NodeType.CLASS) : new OntologyNode(id.toString(), this.getLabelName(id.toString()), nodeType);
        return node;
    }

    private List<OntologyNode> getInstances(String className) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        ArrayList<OntologyNode> result = new ArrayList<OntologyNode>();
        TupleQueryResult queryResult = this.getQueryResult(QueryBuilder.getInstances(className));
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            Value valueOfX = bindingSet.getValue("s");
            result.add(this.makeNode(valueOfX.toString(), NodeType.INSTANCE));
        }
        return BackgroundKnowledgeUtils.filterDuplicates(result);
    }
}

