/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage;

import java.util.HashMap;
import javax.persistence.EntityManager;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.streampipes.empire.core.empire.Empire;
import org.streampipes.empire.core.empire.EmpireOptions;
import org.streampipes.empire.core.empire.config.EmpireConfiguration;
import org.streampipes.empire.core.empire.spi.EmpirePersistenceProvider;
import org.streampipes.empire.core.empire.util.EmpireModule;
import org.streampipes.empire.rdf4j.OpenRdfEmpireModule;
import org.streampipes.serializers.jsonld.CustomAnnotationProvider;
import org.streampipes.storage.api.IBackgroundKnowledgeStorage;
import org.streampipes.storage.api.IOntologyContextStorage;
import org.streampipes.storage.api.IPipelineElementDescriptionStorage;
import org.streampipes.storage.api.ITripleStorage;
import org.streampipes.storage.rdf4j.impl.BackgroundKnowledgeStorageImpl;
import org.streampipes.storage.rdf4j.impl.ContextStorageImpl;
import org.streampipes.storage.rdf4j.impl.InMemoryStorage;
import org.streampipes.storage.rdf4j.impl.SesameStorageRequests;
import org.streampipes.storage.rdf4j.util.SesameConfig;

public enum Rdf4JStorageManager implements ITripleStorage
{
    INSTANCE;

    private EntityManager storageManager;
    private Repository repository;
    private Repository bkrepo;
    private InMemoryStorage inMemoryStorage;
    private IBackgroundKnowledgeStorage backgroundKnowledgeStorage;
    private boolean inMemoryInitialized = false;

    private Rdf4JStorageManager() {
        this.initSesameDatabases();
    }

    public void initSesameDatabases() {
        this.initStorage();
        this.initEmpire();
        this.initBackgroundKnowledgeStorage();
    }

    private void initBackgroundKnowledgeStorage() {
        this.bkrepo = new HTTPRepository(SesameConfig.INSTANCE.getUri(), SesameConfig.INSTANCE.getRepositoryId());
        try {
            this.bkrepo.initialize();
            this.backgroundKnowledgeStorage = new BackgroundKnowledgeStorageImpl(this.bkrepo);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private boolean initStorage() {
        try {
            this.repository = new HTTPRepository(SesameConfig.INSTANCE.getUri(), SesameConfig.INSTANCE.getRepositoryId());
            this.initEmpire();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean initEmpire() {
        try {
            EmpireOptions.STRICT_MODE = false;
            EmpireConfiguration empireCfg = new EmpireConfiguration();
            empireCfg.setAnnotationProvider(CustomAnnotationProvider.class);
            Empire.init((EmpireConfiguration)empireCfg, (EmpireModule[])new EmpireModule[]{new OpenRdfEmpireModule()});
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("repo_handle", this.repository);
            map.put("factory", "sesame");
            map.put("name", "sepa-server");
            map.put("url", SesameConfig.INSTANCE.getUri());
            map.put("repo", SesameConfig.INSTANCE.getRepositoryId());
            EmpirePersistenceProvider provider = Empire.get().persistenceProvider();
            this.storageManager = provider.createEntityManagerFactory("sepa-server", map).createEntityManager();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public IBackgroundKnowledgeStorage getBackgroundKnowledgeStorage() {
        if (this.backgroundKnowledgeStorage == null) {
            this.initSesameDatabases();
        }
        return this.backgroundKnowledgeStorage;
    }

    public Repository getRepository() {
        return this.bkrepo;
    }

    public IPipelineElementDescriptionStorage getStorageAPI() {
        if (this.backgroundKnowledgeStorage == null) {
            this.initSesameDatabases();
        }
        if (!this.inMemoryInitialized) {
            this.inMemoryStorage = new InMemoryStorage(this.getSesameStorage());
            this.inMemoryInitialized = true;
        }
        return this.inMemoryStorage;
    }

    public EntityManager getEntityManager() {
        return this.storageManager;
    }

    public IOntologyContextStorage getContextStorage() {
        return new ContextStorageImpl(this.bkrepo);
    }

    public IPipelineElementDescriptionStorage getSesameStorage() {
        return new SesameStorageRequests();
    }
}

