/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage.rdf4j.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.streampipes.model.client.ontology.Context;
import org.streampipes.model.client.ontology.RdfFormat;
import org.streampipes.storage.api.IOntologyContextStorage;

public class ContextStorageImpl
implements IOntologyContextStorage {
    private Repository repository;

    public ContextStorageImpl(Repository repository) {
        this.repository = repository;
    }

    public boolean addContext(Context context) {
        try {
            RepositoryConnection conn = this.getConnection();
            ValueFactory vf = conn.getValueFactory();
            RDFParser rdfParser = this.getParser(context.getRdfFormat());
            StatementCollector handler = new StatementCollector();
            rdfParser.setRDFHandler((RDFHandler)handler);
            rdfParser.parse(context.getInputStream(), context.getBaseUri());
            Collection col = handler.getStatements();
            for (Statement statement : col) {
                conn.add(statement, new Resource[]{vf.createURI(context.getContextId())});
            }
            this.closeConnection(conn);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private RDFParser getParser(RdfFormat rdfFormat) {
        if (rdfFormat == RdfFormat.RDFXML) {
            return Rio.createParser((RDFFormat)RDFFormat.RDFXML);
        }
        if (rdfFormat == RdfFormat.JSONLD) {
            return Rio.createParser((RDFFormat)RDFFormat.JSONLD);
        }
        if (rdfFormat == RdfFormat.TURTLE) {
            return Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        }
        if (rdfFormat == RdfFormat.RDFA) {
            return Rio.createParser((RDFFormat)RDFFormat.RDFA);
        }
        return Rio.createParser((RDFFormat)RDFFormat.N3);
    }

    public boolean deleteContext(String contextId) {
        try {
            RepositoryConnection conn = this.getConnection();
            conn.clear(new Resource[]{conn.getValueFactory().createURI(contextId)});
            this.closeConnection(conn);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getAvailableContexts() {
        ArrayList<String> contexts = new ArrayList<String>();
        try {
            RepositoryConnection conn = this.getConnection();
            RepositoryResult result = conn.getContextIDs();
            while (result.hasNext()) {
                Resource resource = (Resource)result.next();
                contexts.add(resource.stringValue());
            }
            this.closeConnection(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contexts;
    }

    private RepositoryConnection getConnection() throws RepositoryException {
        return this.repository.getConnection();
    }

    private void closeConnection(RepositoryConnection connection) throws RepositoryException {
        connection.close();
    }
}

