/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage.rdf4j.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSourceDescription;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.storage.Rdf4JStorageManager;
import org.streampipes.storage.api.IPipelineElementDescriptionStorage;
import org.streampipes.storage.rdf4j.sparql.QueryBuilder;
import org.streampipes.storage.rdf4j.util.Transformer;

public class SesameStorageRequests
implements IPipelineElementDescriptionStorage {
    private static final Logger LOG = LoggerFactory.getLogger(SesameStorageRequests.class);
    private EntityManager entityManager;

    public SesameStorageRequests() {
        Rdf4JStorageManager manager = Rdf4JStorageManager.INSTANCE;
        this.entityManager = manager.getEntityManager();
    }

    public boolean storeSEP(DataSourceDescription sep) {
        if (this.exists(sep)) {
            return false;
        }
        this.entityManager.persist((Object)sep);
        return true;
    }

    public boolean storeSEP(String jsonld) {
        try {
            DataSourceDescription sep = Transformer.fromJsonLd(DataSourceDescription.class, jsonld);
            return this.storeSEP(sep);
        }
        catch (IOException | RepositoryException | RDFParseException | UnsupportedRDFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean storeSEPA(DataProcessorDescription sepa) {
        if (this.existsSepa(sepa.getElementId())) {
            return false;
        }
        this.entityManager.persist((Object)sepa);
        return true;
    }

    public boolean existsSepa(String rdfId) {
        DataProcessorDescription storedSEPA = (DataProcessorDescription)this.entityManager.find(DataProcessorDescription.class, (Object)rdfId);
        return storedSEPA != null;
    }

    public boolean storeSEPA(String jsonld) {
        try {
            DataProcessorDescription sepa = Transformer.fromJsonLd(DataProcessorDescription.class, jsonld);
            return this.storeSEPA(sepa);
        }
        catch (IOException | RepositoryException | RDFParseException | UnsupportedRDFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public DataSourceDescription getSEPById(URI rdfId) {
        return (DataSourceDescription)this.entityManager.find(DataSourceDescription.class, (Object)rdfId);
    }

    public DataSourceDescription getSEPByAppId(String appId) {
        return this.getByAppId(this.getAllSEPs(), appId);
    }

    public DataSourceDescription getSEPById(String rdfId) throws URISyntaxException {
        return this.getSEPById(new URI(rdfId));
    }

    public List<DataSourceDescription> getAllSEPs() {
        Query query = this.entityManager.createQuery(QueryBuilder.buildListSEPQuery());
        query.setHint("entity-class", DataSourceDescription.class);
        return query.getResultList();
    }

    public List<DataProcessorDescription> getAllSEPAs() {
        Query query = this.entityManager.createQuery(QueryBuilder.buildListSEPAQuery());
        query.setHint("entity-class", DataProcessorDescription.class);
        return query.getResultList();
    }

    public boolean deleteSEP(DataSourceDescription sep) {
        this.deleteSEP(sep.getElementId());
        return true;
    }

    public boolean deleteSEP(String rdfId) {
        DataSourceDescription sep = (DataSourceDescription)this.entityManager.find(DataSourceDescription.class, (Object)rdfId);
        this.entityManager.remove((Object)sep);
        return true;
    }

    public boolean deleteSEPA(DataProcessorDescription sepa) {
        this.deleteSEPA(sepa.getElementId());
        return true;
    }

    public boolean deleteSEPA(String rdfId) {
        DataProcessorDescription sepa = (DataProcessorDescription)this.entityManager.find(DataProcessorDescription.class, (Object)rdfId);
        this.entityManager.remove((Object)sepa);
        return true;
    }

    public boolean exists(DataSourceDescription sep) {
        DataSourceDescription storedSEP = (DataSourceDescription)this.entityManager.find(DataSourceDescription.class, (Object)sep.getElementId());
        return storedSEP != null;
    }

    public boolean exists(DataProcessorDescription sepa) {
        DataProcessorDescription storedSEPA = (DataProcessorDescription)this.entityManager.find(DataProcessorDescription.class, (Object)sepa.getElementId());
        return storedSEPA != null;
    }

    public boolean update(DataSourceDescription sep) {
        return this.deleteSEP(sep) && this.storeSEP(sep);
    }

    public boolean update(DataProcessorDescription sepa) {
        return this.deleteSEPA(sepa) && this.storeSEPA(sepa);
    }

    public List<DataSourceDescription> getSEPsByDomain(String domain) {
        Query query = this.entityManager.createQuery(QueryBuilder.buildSEPByDomainQuery(domain));
        query.setHint("entity-class", DataSourceDescription.class);
        LOG.info(query.toString());
        return query.getResultList();
    }

    public List<DataProcessorDescription> getSEPAsByDomain(String domain) {
        Query query = this.entityManager.createQuery(QueryBuilder.buildSEPAByDomainQuery(domain));
        query.setHint("entity-class", DataProcessorDescription.class);
        LOG.info(query.toString());
        return query.getResultList();
    }

    public DataProcessorDescription getSEPAById(String rdfId) throws URISyntaxException {
        return this.getSEPAById(new URI(rdfId));
    }

    public DataProcessorDescription getSEPAById(URI rdfId) {
        return (DataProcessorDescription)this.entityManager.find(DataProcessorDescription.class, (Object)rdfId);
    }

    public DataProcessorDescription getSEPAByAppId(String appId) {
        return this.getByAppId(this.getAllSEPAs(), appId);
    }

    public DataSinkDescription getSECById(String rdfId) throws URISyntaxException {
        return this.getSECById(new URI(rdfId));
    }

    public DataSinkDescription getSECById(URI rdfId) {
        return (DataSinkDescription)this.entityManager.find(DataSinkDescription.class, (Object)rdfId);
    }

    public DataSinkDescription getSECByAppId(String appId) {
        return this.getByAppId(this.getAllSECs(), appId);
    }

    public boolean exists(DataSinkDescription sec) {
        DataSinkDescription storedSEC = (DataSinkDescription)this.entityManager.find(DataSinkDescription.class, (Object)sec.getElementId());
        return storedSEC != null;
    }

    public boolean update(DataSinkDescription sec) {
        return this.deleteSEC(sec) && this.storeSEC(sec);
    }

    public boolean deleteSEC(DataSinkDescription sec) {
        return this.deleteSEC(sec.getElementId());
    }

    public boolean deleteSEC(String rdfId) {
        DataSinkDescription sec = (DataSinkDescription)this.entityManager.find(DataSinkDescription.class, (Object)rdfId);
        this.entityManager.remove((Object)sec);
        return true;
    }

    public boolean storeSEC(DataSinkDescription sec) {
        if (this.exists(sec)) {
            return false;
        }
        this.entityManager.persist((Object)sec);
        return true;
    }

    public List<DataSinkDescription> getAllSECs() {
        Query query = this.entityManager.createQuery(QueryBuilder.buildListSECQuery());
        query.setHint("entity-class", DataSinkDescription.class);
        return query.getResultList();
    }

    public StaticProperty getStaticPropertyById(String rdfId) {
        return (StaticProperty)this.entityManager.find(StaticProperty.class, (Object)URI.create(rdfId));
    }

    public boolean storeInvocableSEPAElement(InvocableStreamPipesEntity element) {
        this.entityManager.persist((Object)element);
        return true;
    }

    public SpDataStream getEventStreamById(String rdfId) {
        return (SpDataStream)this.entityManager.find(SpDataStream.class, (Object)URI.create(rdfId));
    }

    private <T extends NamedStreamPipesEntity> T getByAppId(List<T> elements, String appId) {
        return (T)((NamedStreamPipesEntity)elements.stream().filter(e -> e.getAppId().equals(appId)).findFirst().orElse(null));
    }
}

