/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.storage.rdf4j.ontology;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.model.client.ontology.PrimitiveRange;
import org.streampipes.model.client.ontology.QuantitativeValueRange;
import org.streampipes.model.client.ontology.Range;
import org.streampipes.model.client.ontology.RangeType;
import org.streampipes.storage.rdf4j.ontology.QueryExecutor;
import org.streampipes.storage.rdf4j.sparql.QueryBuilder;

public class RangeQueryExecutor
extends QueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RangeQueryExecutor.class);
    private static final String RANGE_TYPE_RDFS_ENUMERATION = "http://sepa.event-processing.org/sepa#Enumeration";
    public static final List<String> RANGE_TYPE_RDFS_LITERAL = Arrays.asList("http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#float");
    private static final String RANGE_TYPE_RDFS_QUANTITATIVE_VALUE = "http://schema.org/QuantitativeValue";
    private Range range;
    private RangeType rangeType;
    private String propertyId;
    private String rangeId;
    private List<String> rangeTypeRdfs;
    private boolean includeValues;
    private String instanceId;

    public RangeQueryExecutor(Repository repository, String propertyId, String rangeId, List<String> rangeTypeRdfs) {
        super(repository);
        this.propertyId = propertyId;
        this.rangeTypeRdfs = rangeTypeRdfs;
        this.includeValues = false;
        this.rangeId = rangeId;
        this.prepare();
    }

    public RangeQueryExecutor(Repository repository, String propertyId, String rangeId, List<String> rangeTypeRdfs, String instanceId) {
        super(repository);
        this.propertyId = propertyId;
        this.rangeTypeRdfs = rangeTypeRdfs;
        this.instanceId = instanceId;
        this.includeValues = true;
        this.rangeId = rangeId;
        this.prepare();
    }

    private void prepare() {
        this.prepareRangeType();
        if (this.rangeType == RangeType.PRIMITIVE) {
            this.range = new PrimitiveRange(this.rangeId);
            if (this.includeValues) {
                try {
                    TupleQueryResult result = this.executeQuery(QueryBuilder.getPrimitivePropertyValue(this.instanceId, this.propertyId));
                    LOG.info(QueryBuilder.getPrimitivePropertyValue(this.instanceId, this.propertyId));
                    while (result.hasNext()) {
                        BindingSet bindingSet = (BindingSet)result.next();
                        Value value = bindingSet.getValue("value");
                        ((PrimitiveRange)this.range).setValue(value.stringValue());
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.rangeType != RangeType.ENUMERATION && this.rangeType == RangeType.QUANTITATIVE_VALUE) {
            this.range = new QuantitativeValueRange();
            if (this.includeValues) {
                try {
                    TupleQueryResult result = this.executeQuery(QueryBuilder.getQuantitativeValueRange(this.propertyId));
                    while (result.hasNext()) {
                        BindingSet bindingSet = (BindingSet)result.next();
                        Value minValue = bindingSet.getValue("minValue");
                        Value maxValue = bindingSet.getValue("maxValue");
                        Value unitCode = bindingSet.getValue("unitCode");
                        ((QuantitativeValueRange)this.range).setMinValue(Integer.parseInt(minValue.stringValue()));
                        ((QuantitativeValueRange)this.range).setMaxValue(Integer.parseInt(maxValue.stringValue()));
                        ((QuantitativeValueRange)this.range).setUnitCode(unitCode.stringValue());
                    }
                }
                catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void prepareRangeType() {
        this.rangeType = this.rangeTypeRdfs.stream().anyMatch(p -> p.startsWith(RANGE_TYPE_RDFS_ENUMERATION)) ? RangeType.ENUMERATION : (this.rangeTypeRdfs.stream().anyMatch(p -> p.startsWith(RANGE_TYPE_RDFS_QUANTITATIVE_VALUE)) ? RangeType.QUANTITATIVE_VALUE : (RANGE_TYPE_RDFS_LITERAL.stream().anyMatch(rt -> this.rangeId.startsWith((String)rt)) ? RangeType.PRIMITIVE : RangeType.RDFS_CLASS));
    }

    public Range getRange() {
        return this.range;
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }
}

