/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.user.management.authentication;

import com.google.gson.JsonObject;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.storage.couchdb.utils.Utils;
import org.streampipes.user.management.authentication.StreamPipesCredentialsMatcher;

public class StreamPipesRealm
implements Realm {
    private static final Logger LOG = LoggerFactory.getLogger(StreamPipesRealm.class);
    private StreamPipesCredentialsMatcher credentialsMatcher = new StreamPipesCredentialsMatcher();

    public String getName() {
        return "StreamPipeRealm";
    }

    public boolean supports(AuthenticationToken authenticationToken) {
        return authenticationToken instanceof UsernamePasswordToken;
    }

    public AuthenticationInfo getAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        if (authenticationToken instanceof UsernamePasswordToken) {
            CouchDbClient dbClient = Utils.getCouchDbUserClient();
            try {
                String email = ((UsernamePasswordToken)authenticationToken).getUsername();
                List users = dbClient.view("users/password").key(new Object[]{email}).includeDocs(Boolean.valueOf(true)).query(JsonObject.class);
                if (users.size() != 1) {
                    throw new AuthenticationException("None or too many users with matching username");
                }
                JsonObject user = (JsonObject)users.get(0);
                String password = user.get("password").getAsString();
                SimpleAuthenticationInfo info = new SimpleAuthenticationInfo();
                SimplePrincipalCollection principals = new SimplePrincipalCollection();
                principals.add((Object)email, this.getName());
                LOG.info(principals.toString());
                info.setPrincipals((PrincipalCollection)principals);
                info.setCredentials((Object)password);
                if (!this.credentialsMatcher.doCredentialsMatch(authenticationToken, (AuthenticationInfo)info)) {
                    throw new AuthenticationException("Could not authenticate");
                }
                System.out.println("User successfully authenticated");
                return info;
            }
            catch (CouchDbException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

