/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.user.management.authentication;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.lightcouch.CouchDbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.user.management.authentication.StreamPipesCredentialsMatcher;
import org.streampipes.user.management.service.UserService;

public class StreamPipesRealm
implements Realm {
    private static final Logger LOG = LoggerFactory.getLogger(StreamPipesRealm.class);
    private StreamPipesCredentialsMatcher credentialsMatcher = new StreamPipesCredentialsMatcher();

    public String getName() {
        return "StreamPipeRealm";
    }

    public boolean supports(AuthenticationToken authenticationToken) {
        return authenticationToken instanceof UsernamePasswordToken;
    }

    public AuthenticationInfo getAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        if (authenticationToken instanceof UsernamePasswordToken) {
            try {
                String email = ((UsernamePasswordToken)authenticationToken).getUsername();
                UserService userService = new UserService(email);
                SimpleAuthenticationInfo info = new SimpleAuthenticationInfo();
                SimplePrincipalCollection principals = new SimplePrincipalCollection();
                principals.add((Object)email, this.getName());
                LOG.info(principals.toString());
                info.setPrincipals((PrincipalCollection)principals);
                info.setCredentials((Object)userService.getPassword());
                if (!this.credentialsMatcher.doCredentialsMatch(authenticationToken, (AuthenticationInfo)info)) {
                    throw new AuthenticationException("Could not authenticate");
                }
                LOG.info("User successfully authenticated");
                return info;
            }
            catch (NullPointerException | CouchDbException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

