/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.user.management.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.streampipes.config.backend.BackendConfig;
import org.streampipes.user.management.service.UserService;

public class CredentialsManager {
    private static final String COLON = ":";
    private static final String TRANSFORMATION = "PBEWithMD5AndDES";

    private static String encrypt(String email, byte[] property) throws GeneralSecurityException {
        String[] userProperties = CredentialsManager.getUserProperties(email);
        byte[] salt = CredentialsManager.getShortenedSalt(userProperties[1]);
        SecretKey key = CredentialsManager.makeSecretKey(userProperties[2].toCharArray());
        Cipher pbeCipher = Cipher.getInstance(TRANSFORMATION);
        pbeCipher.init(1, (Key)key, new PBEParameterSpec(salt, 20));
        return Base64.getEncoder().encodeToString(pbeCipher.doFinal(property));
    }

    private static String encrypt(String email, char[] property) throws GeneralSecurityException {
        byte[] bytes = new byte[property.length];
        for (int i = 0; i < property.length; ++i) {
            bytes[i] = (byte)property[i];
        }
        return CredentialsManager.encrypt(email, bytes);
    }

    public static String encrypt(String email, String property) throws GeneralSecurityException {
        return CredentialsManager.encrypt(email, property.getBytes());
    }

    public static String decrypt(String email, String property) throws GeneralSecurityException {
        String[] userProperties = CredentialsManager.getUserProperties(email);
        byte[] salt = CredentialsManager.getShortenedSalt(userProperties[1]);
        SecretKey key = CredentialsManager.makeSecretKey(userProperties[2].toCharArray());
        Cipher pbeCipher = Cipher.getInstance(TRANSFORMATION);
        pbeCipher.init(2, (Key)key, new PBEParameterSpec(salt, 20));
        return new String(pbeCipher.doFinal(Base64.getDecoder().decode(property)));
    }

    private static SecretKey makeSecretKey(char[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(TRANSFORMATION);
        return keyFactory.generateSecret(new PBEKeySpec(key));
    }

    private static String[] getUserProperties(String email) {
        String hashedProperty = new UserService(email).getPassword();
        return hashedProperty.split(COLON);
    }

    private static byte[] getShortenedSalt(String salt) {
        String mergedSalt = DigestUtils.sha256Hex((String)(salt + CredentialsManager.getBackendEncryptionKey()));
        return Arrays.copyOfRange(mergedSalt.getBytes(), 0, 8);
    }

    private static String getBackendEncryptionKey() {
        return BackendConfig.INSTANCE.getEncryptionKey();
    }
}

