/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.wrapper.siddhi.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.runtime.EventFactory;
import org.streampipes.model.runtime.SchemaInfo;
import org.streampipes.model.runtime.SourceInfo;
import org.streampipes.wrapper.context.EventProcessorRuntimeContext;
import org.streampipes.wrapper.params.binding.EventProcessorBindingParams;
import org.streampipes.wrapper.routing.SpOutputCollector;
import org.streampipes.wrapper.runtime.EventProcessor;
import org.streampipes.wrapper.siddhi.engine.SiddhiDebugCallback;
import org.streampipes.wrapper.siddhi.manager.SpSiddhiManager;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;

public abstract class SiddhiEventEngine<B extends EventProcessorBindingParams>
implements EventProcessor<B> {
    private StringBuilder siddhiAppString = new StringBuilder();
    private SiddhiAppRuntime siddhiAppRuntime;
    private Map<String, InputHandler> siddhiInputHandlers = new HashMap<String, InputHandler>();
    private List<String> inputStreamNames = new ArrayList<String>();
    private List<String> sortedEventKeys = new ArrayList<String>();
    private Boolean debugMode = false;
    private SiddhiDebugCallback debugCallback;
    private static final Logger LOG = LoggerFactory.getLogger(SiddhiEventEngine.class);

    public SiddhiEventEngine() {
    }

    public SiddhiEventEngine(SiddhiDebugCallback debugCallback) {
        this();
        this.debugCallback = debugCallback;
        this.debugMode = true;
    }

    public void onInvocation(B parameters, final SpOutputCollector spOutputCollector, EventProcessorRuntimeContext runtimeContext) {
        if (parameters.getInEventTypes().size() != ((DataProcessorInvocation)parameters.getGraph()).getInputStreams().size()) {
            throw new IllegalArgumentException("Input parameters do not match!");
        }
        SiddhiManager siddhiManager = SpSiddhiManager.INSTANCE.getSiddhiManager();
        LOG.info("Configuring event types for graph " + ((DataProcessorInvocation)parameters.getGraph()).getName());
        parameters.getInEventTypes().forEach((key, value) -> {
            this.registerEventTypeIfNotExists((String)key, (Map<String, Object>)value);
            this.inputStreamNames.add(this.prepareName((String)key));
        });
        String fromStatement = this.fromStatement(this.inputStreamNames, parameters);
        String selectStatement = this.selectStatement(parameters);
        this.registerStatements(fromStatement, selectStatement, this.getOutputTopicName(parameters));
        this.siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(this.siddhiAppString.toString());
        parameters.getInEventTypes().forEach((key, value) -> this.siddhiInputHandlers.put((String)key, this.siddhiAppRuntime.getInputHandler(this.prepareName((String)key))));
        if (!this.debugMode.booleanValue()) {
            this.siddhiAppRuntime.addCallback(this.prepareName(this.getOutputTopicName(parameters)), new StreamCallback((EventProcessorBindingParams)parameters, runtimeContext){
                final /* synthetic */ EventProcessorBindingParams val$parameters;
                final /* synthetic */ EventProcessorRuntimeContext val$runtimeContext;
                {
                    this.val$parameters = eventProcessorBindingParams;
                    this.val$runtimeContext = eventProcessorRuntimeContext;
                }

                public void receive(Event[] events) {
                    if (events.length > 0) {
                        Event lastEvent = events[events.length - 1];
                        spOutputCollector.collect(SiddhiEventEngine.this.toSpEvent(lastEvent, this.val$parameters, this.val$runtimeContext.getOutputSchemaInfo(), this.val$runtimeContext.getOutputSourceInfo()));
                    }
                }
            });
        } else {
            this.siddhiAppRuntime.addCallback(this.prepareName(this.getOutputTopicName(parameters)), new StreamCallback(){

                public void receive(Event[] events) {
                    LOG.info("Siddhi is firing");
                    if (events.length > 0) {
                        SiddhiEventEngine.this.debugCallback.onEvent(events[events.length - 1]);
                    }
                }
            });
        }
    }

    private String getOutputTopicName(B parameters) {
        return ((DataProcessorInvocation)parameters.getGraph()).getOutputStream().getEventGrounding().getTransportProtocol().getTopicDefinition().getActualTopicName();
    }

    private org.streampipes.model.runtime.Event toSpEvent(Event event, B parameters, SchemaInfo schemaInfo, SourceInfo sourceInfo) {
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        for (int i = 0; i < this.sortedEventKeys.size(); ++i) {
            outMap.put(this.sortedEventKeys.get(i), event.getData(i));
        }
        return EventFactory.fromMap(outMap, (SourceInfo)sourceInfo, (SchemaInfo)schemaInfo);
    }

    private void registerEventTypeIfNotExists(String eventTypeName, Map<String, Object> typeMap) {
        String defineStreamPrefix = "define stream " + this.prepareName(eventTypeName);
        StringJoiner joiner = new StringJoiner(",");
        for (String key : typeMap.keySet()) {
            this.sortedEventKeys.add(key);
            Collections.sort(this.sortedEventKeys);
        }
        for (String key : this.sortedEventKeys) {
            joiner.add("s0" + key + " " + this.toType((Class)typeMap.get(key)));
        }
        this.siddhiAppString.append(defineStreamPrefix);
        this.siddhiAppString.append("(");
        this.siddhiAppString.append(joiner.toString());
        this.siddhiAppString.append(");\n");
    }

    private String toType(Class<?> o) {
        if (o.equals(Long.class)) {
            return "LONG";
        }
        if (o.equals(Integer.class)) {
            return "INT";
        }
        if (o.equals(Double.class)) {
            return "DOUBLE";
        }
        if (o.equals(Float.class)) {
            return "DOUBLE";
        }
        if (o.equals(Boolean.class)) {
            return "BOOL";
        }
        return "STRING";
    }

    private void registerStatements(String fromStatement, String selectStatement, String outputStream) {
        this.siddhiAppString.append(fromStatement).append("\n").append(selectStatement).append("\n").append("insert into ").append(this.prepareName(outputStream)).append(";");
        LOG.info("Registering statement: \n" + this.siddhiAppString.toString());
    }

    public void onEvent(org.streampipes.model.runtime.Event event, SpOutputCollector collector) {
        try {
            this.siddhiInputHandlers.get(event.getSourceInfo().getSourceId()).send(this.toObjArr(event.getRaw()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Object[] toObjArr(Map<String, Object> event) {
        Object[] result = new Object[this.sortedEventKeys.size()];
        for (int i = 0; i < this.sortedEventKeys.size(); ++i) {
            result[i] = event.get(this.sortedEventKeys.get(i));
        }
        return result;
    }

    public void onDetach() {
        this.siddhiAppRuntime.shutdown();
    }

    protected abstract String fromStatement(List<String> var1, B var2);

    protected abstract String selectStatement(B var1);

    protected String prepareName(String eventName) {
        return eventName.replaceAll("\\.", "").replaceAll("-", "").replaceAll("::", "");
    }

    protected String getCustomOutputSelectStatement(DataProcessorInvocation invocation, String eventName) {
        StringBuilder selectString = new StringBuilder();
        selectString.append("select ");
        if (this.sortedEventKeys.size() > 0) {
            for (int i = 0; i < this.sortedEventKeys.size() - 1; ++i) {
                selectString.append(eventName + ".s0" + this.sortedEventKeys.get(i) + ",");
            }
            selectString.append(eventName + ".s0" + this.sortedEventKeys.get(this.sortedEventKeys.size() - 1));
        }
        return selectString.toString();
    }

    protected String getCustomOutputSelectStatement(DataProcessorInvocation invocation) {
        return this.getCustomOutputSelectStatement(invocation, "e1");
    }

    public void setSortedEventKeys(List<String> sortedEventKeys) {
        this.sortedEventKeys = sortedEventKeys;
    }
}

