/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.wrapper.standalone.engine;

import java.util.Map;
import java.util.Optional;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.wrapper.params.binding.EventProcessorBindingParams;
import org.streampipes.wrapper.routing.SpOutputCollector;
import org.streampipes.wrapper.runtime.EventProcessor;

public abstract class StandaloneEventProcessorEngine<B extends EventProcessorBindingParams>
extends EventProcessor<B> {
    private Optional<SpOutputCollector> collectorOpt;

    public StandaloneEventProcessorEngine(B params) {
        super(params);
    }

    public void bind(B parameters, SpOutputCollector collector) {
        this.collectorOpt = Optional.of(collector);
        this.onInvocation(parameters, (DataProcessorInvocation)parameters.getGraph());
    }

    public void onEvent(Map<String, Object> event, String sourceInfo) {
        if (!this.collectorOpt.isPresent()) {
            throw new IllegalArgumentException("");
        }
        this.onEvent(event, sourceInfo, this.collectorOpt.get());
    }

    public void discard() {
        this.collectorOpt = Optional.empty();
        this.onDetach();
    }

    public abstract void onInvocation(B var1, DataProcessorInvocation var2);

    public abstract void onEvent(Map<String, Object> var1, String var2, SpOutputCollector var3);

    public abstract void onDetach();
}

