/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.wrapper.standalone.manager;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.wrapper.standalone.routing.StandaloneSpInputCollector;
import org.streampipes.wrapper.standalone.routing.StandaloneSpOutputCollector;

public class ProtocolManager {
    public static Map<String, StandaloneSpInputCollector> consumers = new HashMap<String, StandaloneSpInputCollector>();
    public static Map<String, StandaloneSpOutputCollector> producers = new HashMap<String, StandaloneSpOutputCollector>();
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolManager.class);

    public static <T extends TransportProtocol> StandaloneSpInputCollector findInputCollector(T protocol, TransportFormat format, Boolean singletonEngine) throws SpRuntimeException {
        if (consumers.containsKey(ProtocolManager.topicName(protocol))) {
            return consumers.get(ProtocolManager.topicName(protocol));
        }
        consumers.put(ProtocolManager.topicName(protocol), ProtocolManager.makeInputCollector(protocol, format, singletonEngine));
        LOG.info("Adding new consumer to consumer map (size=" + consumers.size() + "): " + ProtocolManager.topicName(protocol));
        return consumers.get(ProtocolManager.topicName(protocol));
    }

    public static <T extends TransportProtocol> StandaloneSpOutputCollector findOutputCollector(T protocol, TransportFormat format) throws SpRuntimeException {
        if (producers.containsKey(ProtocolManager.topicName(protocol))) {
            return producers.get(ProtocolManager.topicName(protocol));
        }
        producers.put(ProtocolManager.topicName(protocol), ProtocolManager.makeOutputCollector(protocol, format));
        LOG.info("Adding new producer to producer map (size=" + producers.size() + "): " + ProtocolManager.topicName(protocol));
        return producers.get(ProtocolManager.topicName(protocol));
    }

    private static <T extends TransportProtocol> StandaloneSpInputCollector makeInputCollector(T protocol, TransportFormat format, Boolean singletonEngine) throws SpRuntimeException {
        return new StandaloneSpInputCollector<T>(protocol, format, singletonEngine);
    }

    public static <T extends TransportProtocol> StandaloneSpOutputCollector makeOutputCollector(T protocol, TransportFormat format) throws SpRuntimeException {
        return new StandaloneSpOutputCollector<T>(protocol, format);
    }

    private static String topicName(TransportProtocol protocol) {
        return protocol.getTopicDefinition().getActualTopicName();
    }

    public static <T extends TransportProtocol> void removeInputCollector(T protocol) throws SpRuntimeException {
        consumers.remove(ProtocolManager.topicName(protocol));
        LOG.info("Removing consumer from consumer map (size=" + consumers.size() + "): " + ProtocolManager.topicName(protocol));
    }

    public static <T extends TransportProtocol> void removeOutputCollector(T protocol) throws SpRuntimeException {
        producers.remove(ProtocolManager.topicName(protocol));
        LOG.info("Removing producer from producer map (size=" + producers.size() + "): " + ProtocolManager.topicName(protocol));
    }
}

