/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.wrapper.standalone.routing;

import java.util.Map;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.messaging.InternalEventProcessor;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.wrapper.routing.SpOutputCollector;
import org.streampipes.wrapper.standalone.manager.ProtocolManager;
import org.streampipes.wrapper.standalone.routing.StandaloneSpCollector;

public class StandaloneSpOutputCollector<T extends TransportProtocol>
extends StandaloneSpCollector<T, InternalEventProcessor<Map<String, Object>>>
implements SpOutputCollector {
    public StandaloneSpOutputCollector(T protocol, TransportFormat format) throws SpRuntimeException {
        super(protocol, format);
    }

    public void onEvent(Map<String, Object> outEvent) {
        try {
            this.protocolDefinition.getProducer().publish(this.dataFormatDefinition.fromMap(outEvent));
        }
        catch (SpRuntimeException e) {
            e.printStackTrace();
        }
    }

    public void connect() throws SpRuntimeException {
        if (!this.protocolDefinition.getProducer().isConnected().booleanValue()) {
            this.protocolDefinition.getProducer().connect(this.transportProtocol);
        }
    }

    public void disconnect() throws SpRuntimeException {
        if (this.protocolDefinition.getProducer().isConnected().booleanValue()) {
            this.protocolDefinition.getProducer().disconnect();
            ProtocolManager.removeOutputCollector(this.transportProtocol);
        }
    }
}

