/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.wrapper.standalone.runtime;

import java.util.Map;
import java.util.function.Supplier;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.wrapper.context.EventProcessorRuntimeContext;
import org.streampipes.wrapper.params.binding.EventProcessorBindingParams;
import org.streampipes.wrapper.params.runtime.EventProcessorRuntimeParams;
import org.streampipes.wrapper.routing.SpInputCollector;
import org.streampipes.wrapper.routing.SpOutputCollector;
import org.streampipes.wrapper.runtime.EventProcessor;
import org.streampipes.wrapper.standalone.manager.ProtocolManager;
import org.streampipes.wrapper.standalone.runtime.StandalonePipelineElementRuntime;

public class StandaloneEventProcessorRuntime<B extends EventProcessorBindingParams>
extends StandalonePipelineElementRuntime<B, DataProcessorInvocation, EventProcessorRuntimeParams<B>, EventProcessorRuntimeContext, EventProcessor<B>> {
    public StandaloneEventProcessorRuntime(Supplier<EventProcessor<B>> supplier, EventProcessorRuntimeParams<B> params) {
        super(supplier, params);
    }

    public SpOutputCollector getOutputCollector() throws SpRuntimeException {
        return ProtocolManager.findOutputCollector(((DataProcessorInvocation)((EventProcessorBindingParams)((EventProcessorRuntimeParams)this.params).getBindingParams()).getGraph()).getOutputStream().getEventGrounding().getTransportProtocol(), (TransportFormat)((DataProcessorInvocation)((EventProcessorBindingParams)((EventProcessorRuntimeParams)this.params).getBindingParams()).getGraph()).getOutputStream().getEventGrounding().getTransportFormats().get(0));
    }

    public void discardRuntime() throws SpRuntimeException {
        this.getInputCollectors().forEach(is -> is.unregisterConsumer(this.instanceId));
        this.discardEngine();
        this.postDiscard();
    }

    public void process(Map<String, Object> rawEvent, String sourceInfo) throws SpRuntimeException {
        ((EventProcessor)this.getEngine()).onEvent(((EventProcessorRuntimeParams)this.params).makeEvent(rawEvent, sourceInfo), this.getOutputCollector());
    }

    public void bindRuntime() throws SpRuntimeException {
        this.bindEngine();
        this.getInputCollectors().forEach(is -> is.registerConsumer(this.instanceId, (Object)this));
        this.prepareRuntime();
    }

    public void prepareRuntime() throws SpRuntimeException {
        for (SpInputCollector spInputCollector : this.getInputCollectors()) {
            spInputCollector.connect();
        }
        this.getOutputCollector().connect();
    }

    public void postDiscard() throws SpRuntimeException {
        for (SpInputCollector spInputCollector : this.getInputCollectors()) {
            spInputCollector.disconnect();
        }
        this.getOutputCollector().disconnect();
    }

    @Override
    public void bindEngine() throws SpRuntimeException {
        ((EventProcessor)this.engine).onInvocation((EventProcessorBindingParams)((EventProcessorRuntimeParams)this.params).getBindingParams(), this.getOutputCollector(), (EventProcessorRuntimeContext)((EventProcessorRuntimeParams)this.params).getRuntimeContext());
    }
}

