/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.wrapper.standalone.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.wrapper.context.RuntimeContext;
import org.streampipes.wrapper.params.binding.BindingParams;
import org.streampipes.wrapper.params.runtime.RuntimeParams;
import org.streampipes.wrapper.routing.RawDataProcessor;
import org.streampipes.wrapper.routing.SpInputCollector;
import org.streampipes.wrapper.runtime.PipelineElement;
import org.streampipes.wrapper.runtime.PipelineElementRuntime;
import org.streampipes.wrapper.standalone.manager.ProtocolManager;

public abstract class StandalonePipelineElementRuntime<B extends BindingParams<I>, I extends InvocableStreamPipesEntity, RP extends RuntimeParams<B, I, RC>, RC extends RuntimeContext, P extends PipelineElement<B, I>>
extends PipelineElementRuntime
implements RawDataProcessor {
    protected RP params;
    protected final P engine;

    public StandalonePipelineElementRuntime(Supplier<P> supplier, RP runtimeParams) {
        this.engine = (PipelineElement)supplier.get();
        this.params = runtimeParams;
    }

    public P getEngine() {
        return this.engine;
    }

    public void discardEngine() throws SpRuntimeException {
        this.engine.onDetach();
    }

    public List<SpInputCollector> getInputCollectors() throws SpRuntimeException {
        ArrayList<SpInputCollector> inputCollectors = new ArrayList<SpInputCollector>();
        for (SpDataStream is : this.params.getBindingParams().getGraph().getInputStreams()) {
            inputCollectors.add(ProtocolManager.findInputCollector(is.getEventGrounding().getTransportProtocol(), (TransportFormat)is.getEventGrounding().getTransportFormats().get(0), this.params.isSingletonEngine()));
        }
        return inputCollectors;
    }

    public abstract void bindEngine() throws SpRuntimeException;
}

