/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.http;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.stubit.http.HttpStubCreationException;

public class HttpStub
implements AutoCloseable {
    private final HttpServer httpServer;
    private final Map<String, String> resourceMap = new HashMap<String, String>();

    public HttpStub() {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(0), 0);
            this.httpServer.start();
            this.httpServer.createContext("/", httpExchange -> {
                String responseBody;
                String path = httpExchange.getRequestURI().getPath();
                if (!this.resourceMap.containsKey(path)) {
                    responseBody = String.format("No resource for path %s", path);
                    httpExchange.sendResponseHeaders(404, 0L);
                } else {
                    responseBody = this.resourceMap.get(path);
                    httpExchange.sendResponseHeaders(200, responseBody.length());
                }
                try (OutputStream responseBodyOutputStream = httpExchange.getResponseBody();){
                    responseBodyOutputStream.write(responseBody.getBytes());
                }
                httpExchange.close();
            });
        }
        catch (IOException e) {
            throw new HttpStubCreationException(e);
        }
    }

    public String address() {
        return String.format("http://localhost:%d", this.httpServer.getAddress().getPort());
    }

    public HttpStub add(String path, String body) {
        this.resourceMap.put(path, body);
        return this;
    }

    public HttpStub add(Map<String, String> map) {
        this.resourceMap.putAll(map);
        return this;
    }

    @Override
    public void close() {
        this.httpServer.stop(0);
    }
}

