/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.http;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import org.stubit.http.HttpStubCreationException;
import org.stubit.http.HttpStubHandler;
import org.stubit.http.Stubbing;

public class HttpStub
implements AutoCloseable {
    private final HttpStubHandler handler;
    private final HttpServer httpServer;
    private final String address;

    public HttpStub() {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(0), 0);
            this.httpServer.start();
            this.address = "http://localhost:%d".formatted(this.httpServer.getAddress().getPort());
            this.handler = new HttpStubHandler(this.address, new ArrayList<Stubbing>());
            this.httpServer.createContext("/", this.handler);
        }
        catch (IOException e) {
            throw new HttpStubCreationException(e);
        }
    }

    public HttpStub add(Stubbing ... stubbings) {
        Collections.addAll(this.handler.stubbedResponses(), stubbings);
        return this;
    }

    public HttpStub reset() {
        this.handler.stubbedResponses().clear();
        return this;
    }

    public String address() {
        return this.address;
    }

    @Override
    public void close() {
        this.httpServer.stop(0);
    }
}

