/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.stubit.http.HttpRequest;
import org.stubit.http.StubbedResponse;
import org.stubit.http.Stubbing;

record HttpStubHandler(String baseUri, List<Stubbing> stubbedResponses) implements HttpHandler
{
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        HttpRequest request = new HttpRequest(httpExchange.getRequestMethod(), httpExchange.getRequestURI(), new String(httpExchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8));
        StubbedResponse response = switch (request.method()) {
            case "POST" -> this.handlePostRequest(request);
            default -> this.handleGetRequest(request);
        };
        httpExchange.getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)response.headers());
        httpExchange.sendResponseHeaders(response.statusCode(), response.body().length());
        try (OutputStream responseBodyOutputStream = httpExchange.getResponseBody();){
            responseBodyOutputStream.write(response.body().getBytes());
        }
        httpExchange.close();
    }

    private StubbedResponse handleGetRequest(HttpRequest request) {
        Optional<Stubbing> stubbing = this.stubbedResponses.stream().filter(stub -> stub.predicate().test(request)).findFirst();
        return stubbing.map(Stubbing::response).orElse(StubbedResponse.response().body("No stubbing for %s".formatted(request)).statusCode(404));
    }

    private StubbedResponse handlePostRequest(HttpRequest request) {
        Optional<Stubbing> stubbing = this.stubbedResponses.stream().filter(stub -> stub.predicate().test(request)).findFirst();
        return stubbing.map(Stubbing::response).orElseGet(() -> {
            URI uri = URI.create("%s%s%s".formatted(this.baseUri, request.uri(), UUID.randomUUID()));
            this.stubbedResponses.add(Stubbing.stub().path(uri.getPath()).method("GET", "PATCH", "PUT").returns(StubbedResponse.response().body(request.body()).statusCode(200)));
            return StubbedResponse.response().body("Added stubbing for %s".formatted(request.uri().getPath())).header("Location", uri.toString()).statusCode(201);
        });
    }
}

