/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.http;

import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.stubit.http.HttpRequest;
import org.stubit.http.MethodPredicate;
import org.stubit.http.PathPredicate;
import org.stubit.http.StubbedResponse;

@NullMarked
public record Stubbing(Predicate<HttpRequest> predicate, StubbedResponse response) {
    public static Builder stub() {
        return new Builder();
    }

    public static class Builder {
        private PathPredicate pathPredicate;
        private MethodPredicate methodPredicate;

        public Builder path(String path) {
            this.pathPredicate = new PathPredicate(path);
            return this;
        }

        public Builder method(String method, String ... furtherMethods) {
            this.methodPredicate = new MethodPredicate(method, furtherMethods);
            return this;
        }

        public Stubbing returns(StubbedResponse response) {
            Predicate<HttpRequest> predicate = httpRequest -> !(this.pathPredicate != null && !this.pathPredicate.test((HttpRequest)httpRequest) || this.methodPredicate != null && !this.methodPredicate.test((HttpRequest)httpRequest));
            return new Stubbing(predicate, response);
        }
    }
}

