/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record StubbedResponse(int statusCode, @Nullable String body, @Nullable Map<String, List<String>> headers) {
    public static Builder response() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String body;
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder header(String name, String ... value) {
            this.headers.computeIfAbsent(name, key -> new ArrayList()).addAll(List.of(value));
            return this;
        }

        public StubbedResponse statusCode(int statusCode) {
            return new StubbedResponse(statusCode, this.body, this.headers);
        }
    }
}

