/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;

public class RandomString {
    private static final UnicodeBlockRange defaultUnicodeBlockRange = UnicodeBlockRange.BASIC_LATIN;

    private RandomString() {
    }

    public static char aRandomCharacterFrom(UnicodeBlockRange unicodeBlockRange) {
        return unicodeBlockRange.randomChar();
    }

    public static char aRandomCharacter() {
        return RandomString.aRandomCharacterFrom(defaultUnicodeBlockRange);
    }

    public static String aRandomString(int length) {
        return RandomString.aString().length(length).build();
    }

    public static Builder aString() {
        return new Builder();
    }

    public static enum UnicodeBlockRange {
        ADLAM(Character.UnicodeBlock.ADLAM, 125184, 125279),
        AEGEAN_NUMBERS(Character.UnicodeBlock.AEGEAN_NUMBERS, 65792, 65855),
        AHOM(Character.UnicodeBlock.AHOM, 71424, 71503),
        ALCHEMICAL_SYMBOLS(Character.UnicodeBlock.ALCHEMICAL_SYMBOLS, 128768, 128895),
        ALPHABETIC_PRESENTATION_FORMS(Character.UnicodeBlock.ALPHABETIC_PRESENTATION_FORMS, 64256, 64335),
        ANATOLIAN_HIEROGLYPHS(Character.UnicodeBlock.ANATOLIAN_HIEROGLYPHS, 82944, 83583),
        ANCIENT_GREEK_MUSICAL_NOTATION(Character.UnicodeBlock.ANCIENT_GREEK_MUSICAL_NOTATION, 119296, 119375),
        ANCIENT_GREEK_NUMBERS(Character.UnicodeBlock.ANCIENT_GREEK_NUMBERS, 65856, 65935),
        ANCIENT_SYMBOLS(Character.UnicodeBlock.ANCIENT_SYMBOLS, 65936, 65999),
        ARABIC(Character.UnicodeBlock.ARABIC, 1536, 1791),
        ARABIC_EXTENDED_A(Character.UnicodeBlock.ARABIC_EXTENDED_A, 2208, 2303),
        ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS(Character.UnicodeBlock.ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS, 126464, 126719),
        ARABIC_PRESENTATION_FORMS_A(Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A, 64336, 65023),
        ARABIC_PRESENTATION_FORMS_B(Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B, 65136, 65279),
        ARABIC_SUPPLEMENT(Character.UnicodeBlock.ARABIC_SUPPLEMENT, 1872, 1919),
        ARMENIAN(Character.UnicodeBlock.ARMENIAN, 1328, 1423),
        ARROWS(Character.UnicodeBlock.ARROWS, 8592, 8703),
        AVESTAN(Character.UnicodeBlock.AVESTAN, 68352, 68415),
        BALINESE(Character.UnicodeBlock.BALINESE, 6912, 7039),
        BAMUM(Character.UnicodeBlock.BAMUM, 42656, 42751),
        BAMUM_SUPPLEMENT(Character.UnicodeBlock.BAMUM_SUPPLEMENT, 92160, 92735),
        BASIC_LATIN(Character.UnicodeBlock.BASIC_LATIN, 0, 127),
        BASSA_VAH(Character.UnicodeBlock.BASSA_VAH, 92880, 92927),
        BATAK(Character.UnicodeBlock.BATAK, 7104, 7167),
        BENGALI(Character.UnicodeBlock.BENGALI, 2432, 2559),
        BHAIKSUKI(Character.UnicodeBlock.BHAIKSUKI, 72704, 72815),
        BLOCK_ELEMENTS(Character.UnicodeBlock.BLOCK_ELEMENTS, 9600, 9631),
        BOPOMOFO(Character.UnicodeBlock.BOPOMOFO, 12544, 12591),
        BOPOMOFO_EXTENDED(Character.UnicodeBlock.BOPOMOFO_EXTENDED, 12704, 12735),
        BOX_DRAWING(Character.UnicodeBlock.BOX_DRAWING, 9472, 9599),
        BRAHMI(Character.UnicodeBlock.BRAHMI, 69632, 69759),
        BRAILLE_PATTERNS(Character.UnicodeBlock.BRAILLE_PATTERNS, 10240, 10495),
        BUGINESE(Character.UnicodeBlock.BUGINESE, 6656, 6687),
        BUHID(Character.UnicodeBlock.BUHID, 5952, 5983),
        BYZANTINE_MUSICAL_SYMBOLS(Character.UnicodeBlock.BYZANTINE_MUSICAL_SYMBOLS, 118784, 119039),
        CARIAN(Character.UnicodeBlock.CARIAN, 66208, 66271),
        CAUCASIAN_ALBANIAN(Character.UnicodeBlock.CAUCASIAN_ALBANIAN, 66864, 66927),
        CHAKMA(Character.UnicodeBlock.CHAKMA, 69888, 69967),
        CHAM(Character.UnicodeBlock.CHAM, 43520, 43615),
        CHEROKEE(Character.UnicodeBlock.CHEROKEE, 5024, 5119),
        CHEROKEE_SUPPLEMENT(Character.UnicodeBlock.CHEROKEE_SUPPLEMENT, 43888, 43967),
        CHESS_SYMBOLS(Character.UnicodeBlock.CHESS_SYMBOLS, 129536, 129647),
        CHORASMIAN(Character.UnicodeBlock.CHORASMIAN, 69552, 69599),
        CJK_COMPATIBILITY(Character.UnicodeBlock.CJK_COMPATIBILITY, 13056, 13311),
        CJK_COMPATIBILITY_FORMS(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, 65072, 65103),
        CJK_COMPATIBILITY_IDEOGRAPHS(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, 63744, 64255),
        CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, 194560, 195103),
        CJK_RADICALS_SUPPLEMENT(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, 11904, 12031),
        CJK_STROKES(Character.UnicodeBlock.CJK_STROKES, 12736, 12783),
        CJK_SYMBOLS_AND_PUNCTUATION(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, 12288, 12351),
        CJK_UNIFIED_IDEOGRAPHS(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, 19968, 40959),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, 13312, 19903),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, 131072, 173791),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C, 173824, 177983),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D, 177984, 178207),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E, 178208, 183983),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F, 183984, 191471),
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G, 196608, 201551),
        COMBINING_DIACRITICAL_MARKS(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS, 768, 879),
        COMBINING_DIACRITICAL_MARKS_EXTENDED(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS_EXTENDED, 6832, 6911),
        COMBINING_DIACRITICAL_MARKS_SUPPLEMENT(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, 7616, 7679),
        COMBINING_HALF_MARKS(Character.UnicodeBlock.COMBINING_HALF_MARKS, 65056, 65071),
        COMMON_INDIC_NUMBER_FORMS(Character.UnicodeBlock.COMMON_INDIC_NUMBER_FORMS, 43056, 43071),
        CONTROL_PICTURES(Character.UnicodeBlock.CONTROL_PICTURES, 9216, 9279),
        COPTIC(Character.UnicodeBlock.COPTIC, 11392, 11519),
        COPTIC_EPACT_NUMBERS(Character.UnicodeBlock.COPTIC_EPACT_NUMBERS, 66272, 66303),
        COUNTING_ROD_NUMERALS(Character.UnicodeBlock.COUNTING_ROD_NUMERALS, 119648, 119679),
        CUNEIFORM(Character.UnicodeBlock.CUNEIFORM, 73728, 74751),
        CUNEIFORM_NUMBERS_AND_PUNCTUATION(Character.UnicodeBlock.CUNEIFORM_NUMBERS_AND_PUNCTUATION, 74752, 74879),
        CURRENCY_SYMBOLS(Character.UnicodeBlock.CURRENCY_SYMBOLS, 8352, 8399),
        CYPRIOT_SYLLABARY(Character.UnicodeBlock.CYPRIOT_SYLLABARY, 67584, 67647),
        CYRILLIC(Character.UnicodeBlock.CYRILLIC, 1024, 1279),
        CYRILLIC_EXTENDED_A(Character.UnicodeBlock.CYRILLIC_EXTENDED_A, 11744, 11775),
        CYRILLIC_EXTENDED_B(Character.UnicodeBlock.CYRILLIC_EXTENDED_B, 42560, 42655),
        CYRILLIC_EXTENDED_C(Character.UnicodeBlock.CYRILLIC_EXTENDED_C, 7296, 7311),
        CYRILLIC_SUPPLEMENTARY(Character.UnicodeBlock.CYRILLIC_SUPPLEMENTARY, 1280, 1327),
        DESERET(Character.UnicodeBlock.DESERET, 66560, 66639),
        DEVANAGARI(Character.UnicodeBlock.DEVANAGARI, 2304, 2431),
        DEVANAGARI_EXTENDED(Character.UnicodeBlock.DEVANAGARI_EXTENDED, 43232, 43263),
        DINGBATS(Character.UnicodeBlock.DINGBATS, 9984, 10175),
        DIVES_AKURU(Character.UnicodeBlock.DIVES_AKURU, 71936, 72031),
        DOGRA(Character.UnicodeBlock.DOGRA, 71680, 71759),
        DOMINO_TILES(Character.UnicodeBlock.DOMINO_TILES, 127024, 127135),
        DUPLOYAN(Character.UnicodeBlock.DUPLOYAN, 113664, 113823),
        EARLY_DYNASTIC_CUNEIFORM(Character.UnicodeBlock.EARLY_DYNASTIC_CUNEIFORM, 74880, 75087),
        EGYPTIAN_HIEROGLYPHS(Character.UnicodeBlock.EGYPTIAN_HIEROGLYPHS, 77824, 78895),
        EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS(Character.UnicodeBlock.EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS, 78896, 78943),
        ELBASAN(Character.UnicodeBlock.ELBASAN, 66816, 66863),
        ELYMAIC(Character.UnicodeBlock.ELYMAIC, 69600, 69631),
        EMOTICONS(Character.UnicodeBlock.EMOTICONS, 128512, 128591),
        ENCLOSED_ALPHANUMERICS(Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS, 9312, 9471),
        ENCLOSED_ALPHANUMERIC_SUPPLEMENT(Character.UnicodeBlock.ENCLOSED_ALPHANUMERIC_SUPPLEMENT, 127232, 127487),
        ENCLOSED_CJK_LETTERS_AND_MONTHS(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS, 12800, 13055),
        ENCLOSED_IDEOGRAPHIC_SUPPLEMENT(Character.UnicodeBlock.ENCLOSED_IDEOGRAPHIC_SUPPLEMENT, 127488, 127743),
        ETHIOPIC(Character.UnicodeBlock.ETHIOPIC, 4608, 4991),
        ETHIOPIC_EXTENDED(Character.UnicodeBlock.ETHIOPIC_EXTENDED, 11648, 11743),
        ETHIOPIC_EXTENDED_A(Character.UnicodeBlock.ETHIOPIC_EXTENDED_A, 43776, 43823),
        ETHIOPIC_SUPPLEMENT(Character.UnicodeBlock.ETHIOPIC_SUPPLEMENT, 4992, 5023),
        GENERAL_PUNCTUATION(Character.UnicodeBlock.GENERAL_PUNCTUATION, 8192, 8303),
        GEOMETRIC_SHAPES(Character.UnicodeBlock.GEOMETRIC_SHAPES, 9632, 9727),
        GEOMETRIC_SHAPES_EXTENDED(Character.UnicodeBlock.GEOMETRIC_SHAPES_EXTENDED, 128896, 129023),
        GEORGIAN(Character.UnicodeBlock.GEORGIAN, 4256, 4351),
        GEORGIAN_EXTENDED(Character.UnicodeBlock.GEORGIAN_EXTENDED, 7312, 7359),
        GEORGIAN_SUPPLEMENT(Character.UnicodeBlock.GEORGIAN_SUPPLEMENT, 11520, 11567),
        GLAGOLITIC(Character.UnicodeBlock.GLAGOLITIC, 11264, 11359),
        GLAGOLITIC_SUPPLEMENT(Character.UnicodeBlock.GLAGOLITIC_SUPPLEMENT, 122880, 122927),
        GOTHIC(Character.UnicodeBlock.GOTHIC, 66352, 66383),
        GRANTHA(Character.UnicodeBlock.GRANTHA, 70400, 70527),
        GREEK_EXTENDED(Character.UnicodeBlock.GREEK_EXTENDED, 7936, 8191),
        GUJARATI(Character.UnicodeBlock.GUJARATI, 2688, 2815),
        GUNJALA_GONDI(Character.UnicodeBlock.GUNJALA_GONDI, 73056, 73135),
        GURMUKHI(Character.UnicodeBlock.GURMUKHI, 2560, 2687),
        HALFWIDTH_AND_FULLWIDTH_FORMS(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS, 65280, 65519),
        HANGUL_COMPATIBILITY_JAMO(Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO, 12592, 12687),
        HANGUL_JAMO(Character.UnicodeBlock.HANGUL_JAMO, 4352, 4607),
        HANGUL_JAMO_EXTENDED_A(Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_A, 43360, 43391),
        HANGUL_JAMO_EXTENDED_B(Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_B, 55216, 55295),
        HANGUL_SYLLABLES(Character.UnicodeBlock.HANGUL_SYLLABLES, 44032, 55215),
        HANIFI_ROHINGYA(Character.UnicodeBlock.HANIFI_ROHINGYA, 68864, 68927),
        HANUNOO(Character.UnicodeBlock.HANUNOO, 5920, 5951),
        HATRAN(Character.UnicodeBlock.HATRAN, 67808, 67839),
        HEBREW(Character.UnicodeBlock.HEBREW, 1424, 1535),
        HIGH_PRIVATE_USE_SURROGATES(Character.UnicodeBlock.HIGH_PRIVATE_USE_SURROGATES, 56192, 56319),
        HIGH_SURROGATES(Character.UnicodeBlock.HIGH_SURROGATES, 55296, 56191),
        HIRAGANA(Character.UnicodeBlock.HIRAGANA, 12352, 12447),
        IDEOGRAPHIC_DESCRIPTION_CHARACTERS(Character.UnicodeBlock.IDEOGRAPHIC_DESCRIPTION_CHARACTERS, 12272, 12287),
        IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION(Character.UnicodeBlock.IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION, 94176, 94207),
        IMPERIAL_ARAMAIC(Character.UnicodeBlock.IMPERIAL_ARAMAIC, 67648, 67679),
        INDIC_SIYAQ_NUMBERS(Character.UnicodeBlock.INDIC_SIYAQ_NUMBERS, 126064, 126143),
        INSCRIPTIONAL_PAHLAVI(Character.UnicodeBlock.INSCRIPTIONAL_PAHLAVI, 68448, 68479),
        INSCRIPTIONAL_PARTHIAN(Character.UnicodeBlock.INSCRIPTIONAL_PARTHIAN, 68416, 68447),
        IPA_EXTENSIONS(Character.UnicodeBlock.IPA_EXTENSIONS, 592, 687),
        JAVANESE(Character.UnicodeBlock.JAVANESE, 43392, 43487),
        KAITHI(Character.UnicodeBlock.KAITHI, 69760, 69839),
        KANA_EXTENDED_A(Character.UnicodeBlock.KANA_EXTENDED_A, 110848, 110895),
        KANA_SUPPLEMENT(Character.UnicodeBlock.KANA_SUPPLEMENT, 110592, 110847),
        KANBUN(Character.UnicodeBlock.KANBUN, 12688, 12703),
        KANGXI_RADICALS(Character.UnicodeBlock.KANGXI_RADICALS, 12032, 12255),
        KANNADA(Character.UnicodeBlock.KANNADA, 3200, 3327),
        KATAKANA(Character.UnicodeBlock.KATAKANA, 12448, 12543),
        KATAKANA_PHONETIC_EXTENSIONS(Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS, 12784, 12799),
        KAYAH_LI(Character.UnicodeBlock.KAYAH_LI, 43264, 43311),
        KHAROSHTHI(Character.UnicodeBlock.KHAROSHTHI, 68096, 68191),
        KHITAN_SMALL_SCRIPT(Character.UnicodeBlock.KHITAN_SMALL_SCRIPT, 101120, 101631),
        KHMER(Character.UnicodeBlock.KHMER, 6016, 6143),
        KHMER_SYMBOLS(Character.UnicodeBlock.KHMER_SYMBOLS, 6624, 6655),
        KHOJKI(Character.UnicodeBlock.KHOJKI, 70144, 70223),
        KHUDAWADI(Character.UnicodeBlock.KHUDAWADI, 70320, 70399),
        LAO(Character.UnicodeBlock.LAO, 3712, 3839),
        LATIN_1_SUPPLEMENT(Character.UnicodeBlock.LATIN_1_SUPPLEMENT, 128, 255),
        LATIN_EXTENDED_A(Character.UnicodeBlock.LATIN_EXTENDED_A, 256, 383),
        LATIN_EXTENDED_ADDITIONAL(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL, 7680, 7935),
        LATIN_EXTENDED_B(Character.UnicodeBlock.LATIN_EXTENDED_B, 384, 591),
        LATIN_EXTENDED_C(Character.UnicodeBlock.LATIN_EXTENDED_C, 11360, 11391),
        LATIN_EXTENDED_D(Character.UnicodeBlock.LATIN_EXTENDED_D, 42784, 43007),
        LATIN_EXTENDED_E(Character.UnicodeBlock.LATIN_EXTENDED_E, 43824, 43887),
        LEPCHA(Character.UnicodeBlock.LEPCHA, 7168, 7247),
        LETTERLIKE_SYMBOLS(Character.UnicodeBlock.LETTERLIKE_SYMBOLS, 8448, 8527),
        LIMBU(Character.UnicodeBlock.LIMBU, 6400, 6479),
        LINEAR_A(Character.UnicodeBlock.LINEAR_A, 67072, 67455),
        LINEAR_B_IDEOGRAMS(Character.UnicodeBlock.LINEAR_B_IDEOGRAMS, 65664, 65791),
        LINEAR_B_SYLLABARY(Character.UnicodeBlock.LINEAR_B_SYLLABARY, 65536, 65663),
        LISU(Character.UnicodeBlock.LISU, 42192, 42239),
        LISU_SUPPLEMENT(Character.UnicodeBlock.LISU_SUPPLEMENT, 73648, 73663),
        LOW_SURROGATES(Character.UnicodeBlock.LOW_SURROGATES, 56320, 57343),
        LYCIAN(Character.UnicodeBlock.LYCIAN, 66176, 66207),
        LYDIAN(Character.UnicodeBlock.LYDIAN, 67872, 67903),
        MAHAJANI(Character.UnicodeBlock.MAHAJANI, 69968, 70015),
        MAHJONG_TILES(Character.UnicodeBlock.MAHJONG_TILES, 126976, 127023),
        MAKASAR(Character.UnicodeBlock.MAKASAR, 73440, 73471),
        MALAYALAM(Character.UnicodeBlock.MALAYALAM, 3328, 3455),
        MANDAIC(Character.UnicodeBlock.MANDAIC, 2112, 2143),
        MANICHAEAN(Character.UnicodeBlock.MANICHAEAN, 68288, 68351),
        MARCHEN(Character.UnicodeBlock.MARCHEN, 72816, 72895),
        MASARAM_GONDI(Character.UnicodeBlock.MASARAM_GONDI, 72960, 73055),
        MATHEMATICAL_ALPHANUMERIC_SYMBOLS(Character.UnicodeBlock.MATHEMATICAL_ALPHANUMERIC_SYMBOLS, 119808, 120831),
        MATHEMATICAL_OPERATORS(Character.UnicodeBlock.MATHEMATICAL_OPERATORS, 8704, 8959),
        MAYAN_NUMERALS(Character.UnicodeBlock.MAYAN_NUMERALS, 119520, 119551),
        MEDEFAIDRIN(Character.UnicodeBlock.MEDEFAIDRIN, 93760, 93855),
        MEETEI_MAYEK(Character.UnicodeBlock.MEETEI_MAYEK, 43968, 44031),
        MEETEI_MAYEK_EXTENSIONS(Character.UnicodeBlock.MEETEI_MAYEK_EXTENSIONS, 43744, 43775),
        MENDE_KIKAKUI(Character.UnicodeBlock.MENDE_KIKAKUI, 124928, 125151),
        MEROITIC_CURSIVE(Character.UnicodeBlock.MEROITIC_CURSIVE, 68000, 68095),
        MEROITIC_HIEROGLYPHS(Character.UnicodeBlock.MEROITIC_HIEROGLYPHS, 67968, 67999),
        MIAO(Character.UnicodeBlock.MIAO, 93952, 94111),
        MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A(Character.UnicodeBlock.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, 10176, 10223),
        MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B(Character.UnicodeBlock.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, 10624, 10751),
        MISCELLANEOUS_SYMBOLS(Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS, 9728, 9983),
        MISCELLANEOUS_SYMBOLS_AND_ARROWS(Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS_AND_ARROWS, 11008, 11263),
        MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS(Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS, 127744, 128511),
        MISCELLANEOUS_TECHNICAL(Character.UnicodeBlock.MISCELLANEOUS_TECHNICAL, 8960, 9215),
        MODI(Character.UnicodeBlock.MODI, 71168, 71263),
        MODIFIER_TONE_LETTERS(Character.UnicodeBlock.MODIFIER_TONE_LETTERS, 42752, 42783),
        MONGOLIAN(Character.UnicodeBlock.MONGOLIAN, 6144, 6319),
        MONGOLIAN_SUPPLEMENT(Character.UnicodeBlock.MONGOLIAN_SUPPLEMENT, 71264, 71295),
        MRO(Character.UnicodeBlock.MRO, 92736, 92783),
        MULTANI(Character.UnicodeBlock.MULTANI, 70272, 70319),
        MUSICAL_SYMBOLS(Character.UnicodeBlock.MUSICAL_SYMBOLS, 119040, 119295),
        MYANMAR(Character.UnicodeBlock.MYANMAR, 4096, 4255),
        MYANMAR_EXTENDED_A(Character.UnicodeBlock.MYANMAR_EXTENDED_A, 43616, 43647),
        MYANMAR_EXTENDED_B(Character.UnicodeBlock.MYANMAR_EXTENDED_B, 43488, 43519),
        NABATAEAN(Character.UnicodeBlock.NABATAEAN, 67712, 67759),
        NANDINAGARI(Character.UnicodeBlock.NANDINAGARI, 72096, 72191),
        NEWA(Character.UnicodeBlock.NEWA, 70656, 70783),
        NEW_TAI_LUE(Character.UnicodeBlock.NEW_TAI_LUE, 6528, 6623),
        NKO(Character.UnicodeBlock.NKO, 1984, 2047),
        NUMBER_FORMS(Character.UnicodeBlock.NUMBER_FORMS, 8528, 8591),
        NUSHU(Character.UnicodeBlock.NUSHU, 110960, 111359),
        NYIAKENG_PUACHUE_HMONG(Character.UnicodeBlock.NYIAKENG_PUACHUE_HMONG, 123136, 123215),
        OGHAM(Character.UnicodeBlock.OGHAM, 5760, 5791),
        OLD_HUNGARIAN(Character.UnicodeBlock.OLD_HUNGARIAN, 68736, 68863),
        OLD_ITALIC(Character.UnicodeBlock.OLD_ITALIC, 66304, 66351),
        OLD_NORTH_ARABIAN(Character.UnicodeBlock.OLD_NORTH_ARABIAN, 68224, 68255),
        OLD_PERMIC(Character.UnicodeBlock.OLD_PERMIC, 66384, 66431),
        OLD_PERSIAN(Character.UnicodeBlock.OLD_PERSIAN, 66464, 66527),
        OLD_SOGDIAN(Character.UnicodeBlock.OLD_SOGDIAN, 69376, 69423),
        OLD_SOUTH_ARABIAN(Character.UnicodeBlock.OLD_SOUTH_ARABIAN, 68192, 68223),
        OLD_TURKIC(Character.UnicodeBlock.OLD_TURKIC, 68608, 68687),
        OL_CHIKI(Character.UnicodeBlock.OL_CHIKI, 7248, 7295),
        OPTICAL_CHARACTER_RECOGNITION(Character.UnicodeBlock.OPTICAL_CHARACTER_RECOGNITION, 9280, 9311),
        ORIYA(Character.UnicodeBlock.ORIYA, 2816, 2943),
        ORNAMENTAL_DINGBATS(Character.UnicodeBlock.ORNAMENTAL_DINGBATS, 128592, 128639),
        OSAGE(Character.UnicodeBlock.OSAGE, 66736, 66815),
        OSMANYA(Character.UnicodeBlock.OSMANYA, 66688, 66735),
        OTTOMAN_SIYAQ_NUMBERS(Character.UnicodeBlock.OTTOMAN_SIYAQ_NUMBERS, 126208, 126287),
        PAHAWH_HMONG(Character.UnicodeBlock.PAHAWH_HMONG, 92928, 93071),
        PALMYRENE(Character.UnicodeBlock.PALMYRENE, 67680, 67711),
        PAU_CIN_HAU(Character.UnicodeBlock.PAU_CIN_HAU, 72384, 72447),
        PHAGS_PA(Character.UnicodeBlock.PHAGS_PA, 43072, 43135),
        PHAISTOS_DISC(Character.UnicodeBlock.PHAISTOS_DISC, 66000, 66047),
        PHOENICIAN(Character.UnicodeBlock.PHOENICIAN, 67840, 67871),
        PHONETIC_EXTENSIONS(Character.UnicodeBlock.PHONETIC_EXTENSIONS, 7424, 7551),
        PHONETIC_EXTENSIONS_SUPPLEMENT(Character.UnicodeBlock.PHONETIC_EXTENSIONS_SUPPLEMENT, 7552, 7615),
        PLAYING_CARDS(Character.UnicodeBlock.PLAYING_CARDS, 127136, 127231),
        PRIVATE_USE_AREA(Character.UnicodeBlock.PRIVATE_USE_AREA, 57344, 63743),
        PSALTER_PAHLAVI(Character.UnicodeBlock.PSALTER_PAHLAVI, 68480, 68527),
        REJANG(Character.UnicodeBlock.REJANG, 43312, 43359),
        RUMI_NUMERAL_SYMBOLS(Character.UnicodeBlock.RUMI_NUMERAL_SYMBOLS, 69216, 69247),
        RUNIC(Character.UnicodeBlock.RUNIC, 5792, 5887),
        SAMARITAN(Character.UnicodeBlock.SAMARITAN, 2048, 2111),
        SAURASHTRA(Character.UnicodeBlock.SAURASHTRA, 43136, 43231),
        SHARADA(Character.UnicodeBlock.SHARADA, 70016, 70111),
        SHAVIAN(Character.UnicodeBlock.SHAVIAN, 66640, 66687),
        SHORTHAND_FORMAT_CONTROLS(Character.UnicodeBlock.SHORTHAND_FORMAT_CONTROLS, 113824, 113839),
        SIDDHAM(Character.UnicodeBlock.SIDDHAM, 71040, 71167),
        SINHALA(Character.UnicodeBlock.SINHALA, 3456, 3583),
        SINHALA_ARCHAIC_NUMBERS(Character.UnicodeBlock.SINHALA_ARCHAIC_NUMBERS, 70112, 70143),
        SMALL_FORM_VARIANTS(Character.UnicodeBlock.SMALL_FORM_VARIANTS, 65104, 65135),
        SMALL_KANA_EXTENSION(Character.UnicodeBlock.SMALL_KANA_EXTENSION, 110896, 110959),
        SOGDIAN(Character.UnicodeBlock.SOGDIAN, 69424, 69487),
        SORA_SOMPENG(Character.UnicodeBlock.SORA_SOMPENG, 69840, 69887),
        SOYOMBO(Character.UnicodeBlock.SOYOMBO, 72272, 72367),
        SPACING_MODIFIER_LETTERS(Character.UnicodeBlock.SPACING_MODIFIER_LETTERS, 688, 767),
        SPECIALS(Character.UnicodeBlock.SPECIALS, 65520, 65535),
        SUNDANESE(Character.UnicodeBlock.SUNDANESE, 7040, 7103),
        SUNDANESE_SUPPLEMENT(Character.UnicodeBlock.SUNDANESE_SUPPLEMENT, 7360, 7375),
        SUPERSCRIPTS_AND_SUBSCRIPTS(Character.UnicodeBlock.SUPERSCRIPTS_AND_SUBSCRIPTS, 8304, 8351),
        SUPPLEMENTAL_ARROWS_A(Character.UnicodeBlock.SUPPLEMENTAL_ARROWS_A, 10224, 10239),
        SUPPLEMENTAL_ARROWS_B(Character.UnicodeBlock.SUPPLEMENTAL_ARROWS_B, 10496, 10623),
        SUPPLEMENTAL_ARROWS_C(Character.UnicodeBlock.SUPPLEMENTAL_ARROWS_C, 129024, 129279),
        SUPPLEMENTAL_MATHEMATICAL_OPERATORS(Character.UnicodeBlock.SUPPLEMENTAL_MATHEMATICAL_OPERATORS, 10752, 11007),
        SUPPLEMENTAL_PUNCTUATION(Character.UnicodeBlock.SUPPLEMENTAL_PUNCTUATION, 11776, 11903),
        SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS(Character.UnicodeBlock.SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS, 129280, 129535),
        SUPPLEMENTARY_PRIVATE_USE_AREA_A(Character.UnicodeBlock.SUPPLEMENTARY_PRIVATE_USE_AREA_A, 983040, 1048575),
        SUPPLEMENTARY_PRIVATE_USE_AREA_B(Character.UnicodeBlock.SUPPLEMENTARY_PRIVATE_USE_AREA_B, 0x100000, 0x10FFFF),
        SUTTON_SIGNWRITING(Character.UnicodeBlock.SUTTON_SIGNWRITING, 120832, 121519),
        SYLOTI_NAGRI(Character.UnicodeBlock.SYLOTI_NAGRI, 43008, 43055),
        SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A(Character.UnicodeBlock.SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A, 129648, 129791),
        SYMBOLS_FOR_LEGACY_COMPUTING(Character.UnicodeBlock.SYMBOLS_FOR_LEGACY_COMPUTING, 129792, 130047),
        SYRIAC(Character.UnicodeBlock.SYRIAC, 1792, 1871),
        SYRIAC_SUPPLEMENT(Character.UnicodeBlock.SYRIAC_SUPPLEMENT, 2144, 2159),
        TAGALOG(Character.UnicodeBlock.TAGALOG, 5888, 5919),
        TAGBANWA(Character.UnicodeBlock.TAGBANWA, 5984, 6015),
        TAGS(Character.UnicodeBlock.TAGS, 917504, 917631),
        TAI_LE(Character.UnicodeBlock.TAI_LE, 6480, 6527),
        TAI_THAM(Character.UnicodeBlock.TAI_THAM, 6688, 6831),
        TAI_VIET(Character.UnicodeBlock.TAI_VIET, 43648, 43743),
        TAI_XUAN_JING_SYMBOLS(Character.UnicodeBlock.TAI_XUAN_JING_SYMBOLS, 119552, 119647),
        TAKRI(Character.UnicodeBlock.TAKRI, 71296, 71375),
        TAMIL(Character.UnicodeBlock.TAMIL, 2944, 3071),
        TAMIL_SUPPLEMENT(Character.UnicodeBlock.TAMIL_SUPPLEMENT, 73664, 73727),
        TANGUT(Character.UnicodeBlock.TANGUT, 94208, 100351),
        TANGUT_COMPONENTS(Character.UnicodeBlock.TANGUT_COMPONENTS, 100352, 101119),
        TANGUT_SUPPLEMENT(Character.UnicodeBlock.TANGUT_SUPPLEMENT, 101632, 101759),
        TELUGU(Character.UnicodeBlock.TELUGU, 3072, 3199),
        THAANA(Character.UnicodeBlock.THAANA, 1920, 1983),
        THAI(Character.UnicodeBlock.THAI, 3584, 3711),
        TIBETAN(Character.UnicodeBlock.TIBETAN, 3840, 4095),
        TIFINAGH(Character.UnicodeBlock.TIFINAGH, 11568, 11647),
        TIRHUTA(Character.UnicodeBlock.TIRHUTA, 70784, 70879),
        TRANSPORT_AND_MAP_SYMBOLS(Character.UnicodeBlock.TRANSPORT_AND_MAP_SYMBOLS, 128640, 128767),
        UGARITIC(Character.UnicodeBlock.UGARITIC, 66432, 66463),
        UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS(Character.UnicodeBlock.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, 5120, 5759),
        UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED(Character.UnicodeBlock.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED, 6320, 6399),
        VAI(Character.UnicodeBlock.VAI, 42240, 42559),
        VARIATION_SELECTORS(Character.UnicodeBlock.VARIATION_SELECTORS, 65024, 65039),
        VARIATION_SELECTORS_SUPPLEMENT(Character.UnicodeBlock.VARIATION_SELECTORS_SUPPLEMENT, 917760, 917999),
        VEDIC_EXTENSIONS(Character.UnicodeBlock.VEDIC_EXTENSIONS, 7376, 7423),
        VERTICAL_FORMS(Character.UnicodeBlock.VERTICAL_FORMS, 65040, 65055),
        WANCHO(Character.UnicodeBlock.WANCHO, 123584, 123647),
        WARANG_CITI(Character.UnicodeBlock.WARANG_CITI, 71840, 71935),
        YEZIDI(Character.UnicodeBlock.YEZIDI, 69248, 69311),
        YIJING_HEXAGRAM_SYMBOLS(Character.UnicodeBlock.YIJING_HEXAGRAM_SYMBOLS, 19904, 19967),
        YI_RADICALS(Character.UnicodeBlock.YI_RADICALS, 42128, 42191),
        YI_SYLLABLES(Character.UnicodeBlock.YI_SYLLABLES, 40960, 42127),
        ZANABAZAR_SQUARE(Character.UnicodeBlock.ZANABAZAR_SQUARE, 72192, 72271);

        private static final SecureRandom secureRandom;
        public final Character.UnicodeBlock block;
        public final char first;
        public final char last;

        private UnicodeBlockRange(Character.UnicodeBlock block, int first, int last) {
            this.block = block;
            this.first = (char)first;
            this.last = (char)last;
        }

        public static UnicodeBlockRange of(Character.UnicodeBlock block) {
            for (UnicodeBlockRange range : UnicodeBlockRange.values()) {
                if (range.block != block) continue;
                return range;
            }
            return null;
        }

        public char randomChar() {
            return (char)secureRandom.nextInt(this.first, this.last + '\u0001');
        }

        static {
            secureRandom = new SecureRandom();
        }
    }

    public static class Builder {
        private UnicodeBlockRange unicodeBlockRange = defaultUnicodeBlockRange;
        private int length = 10;

        public Builder unicodeBlock(UnicodeBlockRange unicodeBlockRange) {
            this.unicodeBlockRange = unicodeBlockRange;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public String build() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.length; ++i) {
                sb.append(this.unicodeBlockRange.randomChar());
            }
            return sb.toString();
        }
    }
}

