/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RandomChoice {
    private RandomChoice() {
    }

    public static <T> T anyOf(Collection<T> choices) {
        return RandomChoice.aChoiceFrom(choices).build();
    }

    public static <K, V> Map.Entry<K, V> anyOf(Map<K, V> choices) {
        return RandomChoice.aChoiceFrom(choices).build();
    }

    @SafeVarargs
    public static <T> T anyOf(T ... choices) {
        return RandomChoice.aChoiceFrom(choices).build();
    }

    public static <T extends Enum<?>> T any(Class<? extends T> enumType) {
        return (T)RandomChoice.anyOf((Enum[])enumType.getEnumConstants());
    }

    public static <T> Builder<T> aChoiceFrom(Collection<T> choices) {
        return new Builder<T>(choices);
    }

    public static <K, V> Builder<Map.Entry<K, V>> aChoiceFrom(Map<K, V> choices) {
        return new Builder<Map.Entry<K, V>>(choices.entrySet());
    }

    @SafeVarargs
    public static <T> Builder<T> aChoiceFrom(T ... choices) {
        return RandomChoice.aChoiceFrom(Arrays.asList(choices));
    }

    public static <T extends Enum<?>> Builder<T> aChoiceFromValuesOf(Class<? extends T> enumType) {
        return RandomChoice.aChoiceFrom(Arrays.asList((Enum[])enumType.getEnumConstants()));
    }

    public static class Builder<T> {
        private static final SecureRandom random = new SecureRandom();
        private final List<T> choices;

        private Builder(Collection<T> choices) {
            if (choices.isEmpty()) {
                throw new IllegalArgumentException("No choices provided");
            }
            this.choices = new ArrayList<T>(choices);
        }

        public Builder<T> and(Collection<T> additionalChoices) {
            this.choices.addAll(additionalChoices);
            return this;
        }

        @SafeVarargs
        public final Builder<T> and(T ... additionalChoices) {
            return this.and((Collection<T>)List.of(additionalChoices));
        }

        public Builder<T> butNot(Collection<T> excluded) {
            this.choices.removeAll(excluded);
            if (this.choices.isEmpty()) {
                throw new IllegalArgumentException("No choices left");
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> butNot(T ... excluded) {
            return this.butNot((Collection<T>)Arrays.asList(excluded));
        }

        public T build() {
            return this.choices.get(random.nextInt(this.choices.size()));
        }
    }
}

