/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;

public class RandomInt {
    private RandomInt() {
    }

    public static int anIntBetween(int minInclusive, int maxInclusive) {
        return RandomInt.anInt().min(minInclusive).max(maxInclusive).build();
    }

    public static int aNegativeInt() {
        return RandomInt.anInt().negative().build();
    }

    public static int aPositiveInt() {
        return RandomInt.anInt().positive().build();
    }

    public static RandomIntBuilder anInt() {
        return new RandomIntBuilder(Integer.MIN_VALUE, 0x7FFFFFFE);
    }

    public static class RandomIntBuilder {
        private final SecureRandom secureRandom = new SecureRandom();
        private int minInclusive;
        private int maxInclusive;

        private RandomIntBuilder(int min, int max) {
            this.minInclusive = min;
            this.maxInclusive = max;
        }

        public RandomIntBuilder positive() {
            return this.min(1).max(0x7FFFFFFE);
        }

        public RandomIntBuilder negative() {
            return this.min(Integer.MIN_VALUE).max(-1);
        }

        public RandomIntBuilder min(int minInclusive) {
            this.minInclusive = minInclusive;
            if (minInclusive > this.maxInclusive) {
                throw new IllegalArgumentException("Can't set min to %d, as it must not be greater than max (%d)".formatted(minInclusive, this.maxInclusive));
            }
            return this;
        }

        public RandomIntBuilder max(int maxInclusive) {
            if (maxInclusive < this.minInclusive) {
                throw new IllegalArgumentException("Can't set max to %d, as it must not be less than min (%d)".formatted(maxInclusive, this.minInclusive));
            }
            if (maxInclusive == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Can't set max to %d (Integer.MAX_VALUE)".formatted(maxInclusive));
            }
            this.maxInclusive = maxInclusive;
            return this;
        }

        public int build() {
            return this.secureRandom.nextInt(this.minInclusive, this.maxInclusive + 1);
        }
    }
}

