/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.stubit.random.Alphabet;
import org.stubit.random.DigitSystem;
import org.stubit.random.RandomChoice;

public class RandomString {
    private RandomString() {
    }

    public static Builder aStringStartingWith(String string) {
        return new Builder(string);
    }

    public static String aLatinLetter() {
        return RandomString.aLetterFrom(Alphabet.BASIC_LATIN);
    }

    public static String latinLetters(int number) {
        return RandomString.lettersFrom(number, Alphabet.BASIC_LATIN);
    }

    public static String anArabicDigit() {
        return RandomString.aDigitFrom(DigitSystem.ARABIC);
    }

    public static String arabicDigits(int number) {
        return RandomString.digitsFrom(number, DigitSystem.ARABIC);
    }

    public static String aLetterFrom(Alphabet alphabet) {
        return RandomChoice.anyOf(alphabet.letters()).toString();
    }

    public static String lettersFrom(int number, Alphabet alphabet) {
        return Stream.generate(() -> RandomString.aLetterFrom(alphabet)).limit(number).collect(Collectors.joining());
    }

    public static String aDigitFrom(DigitSystem digitSystem) {
        return RandomChoice.anyOf(digitSystem.digits()).toString();
    }

    public static String digitsFrom(int number, DigitSystem digitSystem) {
        return Stream.generate(() -> RandomString.aDigitFrom(digitSystem)).limit(number).collect(Collectors.joining());
    }

    public static class Builder {
        private final StringBuilder stringBuilder;

        private Builder(String startString) {
            this.stringBuilder = new StringBuilder(startString);
        }

        public Builder followedBy(String string) {
            this.stringBuilder.append(string);
            return this;
        }

        public String build() {
            return this.stringBuilder.toString();
        }
    }
}

