/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;
import java.time.Duration;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RandomDuration {
    private RandomDuration() {
    }

    public static Duration aDurationBetween(Duration minInclusive, Duration maxInclusive) {
        return RandomDuration.aDuration().min(minInclusive).max(maxInclusive).build();
    }

    public static RandomDurationBuilder aDuration() {
        return new RandomDurationBuilder(Duration.ZERO, Duration.ofSeconds(0x7FFFFFFFFFFFFFFEL));
    }

    public static class RandomDurationBuilder {
        private final SecureRandom secureRandom = new SecureRandom();
        private Duration minInclusive;
        private Duration maxInclusive;

        private RandomDurationBuilder(Duration min, Duration max) {
            this.minInclusive = min;
            this.maxInclusive = max;
        }

        public RandomDurationBuilder min(Duration minInclusive) {
            this.minInclusive = minInclusive;
            if (minInclusive.compareTo(this.maxInclusive) > 0) {
                throw new IllegalArgumentException("Can't set min to %s, as it must not be greater than max (%s)".formatted(minInclusive, this.maxInclusive));
            }
            return this;
        }

        public RandomDurationBuilder max(Duration maxInclusive) {
            if (this.minInclusive.compareTo(maxInclusive) > 0) {
                throw new IllegalArgumentException("Can't set max to %s, as it must not be less than min (%s)".formatted(maxInclusive, this.minInclusive));
            }
            this.maxInclusive = maxInclusive;
            return this;
        }

        public Duration build() {
            return Duration.ofSeconds(this.secureRandom.nextLong(this.minInclusive.toSeconds(), this.maxInclusive.toSeconds() + 1L));
        }
    }
}

