/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RandomLocalDate {
    private RandomLocalDate() {
    }

    public static LocalDate aLocalDateBetween(LocalDate after, LocalDate before) {
        return RandomLocalDate.aLocalDateInRange().after(after).before(before).build();
    }

    public static LocalDate aPastLocalDate() {
        return RandomLocalDate.aLocalDateInRange().past().build();
    }

    public static LocalDate aFutureLocalDate() {
        return RandomLocalDate.aLocalDateInRange().future().build();
    }

    public static LocalDateInRangeBuilder aLocalDateInRange() {
        return new LocalDateInRangeBuilder(LocalDate.MIN, LocalDate.MAX);
    }

    public static LocalDateBuilder aLocalDate() {
        return new LocalDateBuilder();
    }

    public static class LocalDateInRangeBuilder {
        private final SecureRandom secureRandom = new SecureRandom();
        private LocalDate after;
        private LocalDate before;

        private LocalDateInRangeBuilder(LocalDate after, LocalDate before) {
            this.after = after;
            this.before = before;
        }

        public LocalDateInRangeBuilder past() {
            return this.after(LocalDate.MIN).before(LocalDate.now().minusDays(1L));
        }

        public LocalDateInRangeBuilder future() {
            return this.after(LocalDate.now().plusDays(1L)).before(LocalDate.MAX);
        }

        public LocalDateInRangeBuilder after(LocalDate after) {
            if (after.isAfter(this.before)) {
                throw new IllegalArgumentException("Can't set after to %s, as it must not be greater than before (%s)".formatted(after, this.before));
            }
            this.after = after;
            return this;
        }

        public LocalDateInRangeBuilder before(LocalDate before) {
            if (before.isBefore(this.after)) {
                throw new IllegalArgumentException("Can't set before to %s, as it must not be less than after (%s)".formatted(before, this.after));
            }
            this.before = before;
            return this;
        }

        public LocalDate build() {
            long minEpochDay = this.after.toEpochDay();
            long maxEpochDay = this.before.toEpochDay() + 1L;
            long randomEpochDay = minEpochDay + this.secureRandom.nextLong(0L, maxEpochDay - minEpochDay);
            return LocalDate.ofEpochDay(randomEpochDay);
        }
    }

    public static class LocalDateBuilder {
        private LocalDate localDate = RandomLocalDate.aLocalDateInRange().build();

        public LocalDateBuilder year(int year) {
            return this.year(Year.of(year));
        }

        public LocalDateBuilder year(Year year) {
            this.localDate = this.localDate.with(year);
            return this;
        }

        public LocalDateBuilder month(int month) {
            return this.month(Month.of(month));
        }

        public LocalDateBuilder month(Month month) {
            this.localDate = this.localDate.with(month);
            return this;
        }

        public LocalDateBuilder dayOfMonth(int day) {
            this.localDate = this.localDate.withDayOfMonth(day);
            return this;
        }

        public LocalDateBuilder dayOfWeek(int dayOfWeek) {
            return this.dayOfWeek(DayOfWeek.of(dayOfWeek));
        }

        public LocalDateBuilder dayOfWeek(DayOfWeek dayOfWeek) {
            this.localDate = this.localDate.with(dayOfWeek);
            return this;
        }

        public LocalDate build() {
            return this.localDate;
        }
    }
}

