/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;
import java.time.LocalTime;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RandomLocalTime {
    private RandomLocalTime() {
    }

    public static LocalTime aLocalTimeBetween(LocalTime after, LocalTime before) {
        return RandomLocalTime.aLocalTimeInRange().after(after).before(before).build();
    }

    public static LocalTime aPastLocalTime() {
        return RandomLocalTime.aLocalTimeInRange().before(LocalTime.now()).build();
    }

    public static LocalTime aFutureLocalTime() {
        return RandomLocalTime.aLocalTimeInRange().after(LocalTime.now()).build();
    }

    public static LocalTimeInRangeBuilder aLocalTimeInRange() {
        return new LocalTimeInRangeBuilder(LocalTime.MIN, LocalTime.MAX);
    }

    public static LocalTimeBuilder aLocalTime() {
        return new LocalTimeBuilder();
    }

    public static class LocalTimeInRangeBuilder {
        private final SecureRandom secureRandom = new SecureRandom();
        private LocalTime after;
        private LocalTime before;

        private LocalTimeInRangeBuilder(LocalTime after, LocalTime before) {
            this.after = after;
            this.before = before;
        }

        public LocalTimeInRangeBuilder past() {
            return this.after(LocalTime.MIN).before(LocalTime.now().minusSeconds(1L));
        }

        public LocalTimeInRangeBuilder future() {
            return this.after(LocalTime.now().plusSeconds(1L)).before(LocalTime.MAX);
        }

        public LocalTimeInRangeBuilder after(LocalTime after) {
            if (after.isAfter(this.before)) {
                throw new IllegalArgumentException("Can't set after to %s, as it must not be greater than before (%s)".formatted(after, this.before));
            }
            this.after = after;
            return this;
        }

        public LocalTimeInRangeBuilder before(LocalTime before) {
            if (before.isBefore(this.after)) {
                throw new IllegalArgumentException("Can't set before to %s, as it must not be less than after (%s)".formatted(before, this.after));
            }
            this.before = before;
            return this;
        }

        public LocalTime build() {
            long minDayNano = this.after.toNanoOfDay();
            long maxDayNano = this.before.toNanoOfDay() + 1L;
            long randomDayNano = minDayNano + this.secureRandom.nextLong(0L, maxDayNano - minDayNano);
            return LocalTime.ofNanoOfDay(randomDayNano);
        }
    }

    public static class LocalTimeBuilder {
        private LocalTime localTime = RandomLocalTime.aLocalTimeInRange().build();

        public LocalTimeBuilder hour(int hour) {
            this.localTime = this.localTime.withHour(hour);
            return this;
        }

        public LocalTimeBuilder minute(int minute) {
            this.localTime = this.localTime.withMinute(minute);
            return this;
        }

        public LocalTimeBuilder second(int second) {
            this.localTime = this.localTime.withSecond(second);
            return this;
        }

        public LocalTimeBuilder nano(int nano) {
            this.localTime = this.localTime.withNano(nano);
            return this;
        }

        public LocalTime build() {
            return this.localTime;
        }
    }
}

