/*
 * Decompiled with CFR 0.152.
 */
package org.stubit.random;

import java.security.SecureRandom;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RandomNumber {
    private RandomNumber() {
    }

    public static int anIntBetween(int minInclusive, int maxInclusive) {
        return RandomNumber.anInt().min(minInclusive).max(maxInclusive).build();
    }

    public static int aNegativeInt() {
        return RandomNumber.anInt().negative().build();
    }

    public static int aPositiveInt() {
        return RandomNumber.anInt().positive().build();
    }

    public static RandomNumberBuilder<Integer> anInt() {
        return new RandomIntBuilder(Integer.MIN_VALUE, 0x7FFFFFFE);
    }

    public static long aLongBetween(long minInclusive, long maxInclusive) {
        return RandomNumber.aLong().min(minInclusive).max(maxInclusive).build();
    }

    public static long aNegativeLong() {
        return RandomNumber.aLong().negative().build();
    }

    public static long aPositiveLong() {
        return RandomNumber.aLong().positive().build();
    }

    public static RandomNumberBuilder<Long> aLong() {
        return new RandomLongBuilder(Long.MIN_VALUE, 0x7FFFFFFFFFFFFFFEL);
    }

    public static interface RandomNumberBuilder<N> {
        public RandomNumberBuilder<N> positive();

        public RandomNumberBuilder<N> negative();

        public RandomNumberBuilder<N> min(N var1);

        public RandomNumberBuilder<N> max(N var1);

        public N build();
    }

    public static class RandomIntBuilder
    implements RandomNumberBuilder<Integer> {
        private final SecureRandom secureRandom = new SecureRandom();
        private int minInclusive;
        private int maxInclusive;

        private RandomIntBuilder(int min, int max) {
            this.minInclusive = min;
            this.maxInclusive = max;
        }

        public RandomIntBuilder positive() {
            return this.min(1).max(0x7FFFFFFE);
        }

        public RandomIntBuilder negative() {
            return this.min(Integer.MIN_VALUE).max(-1);
        }

        public RandomIntBuilder min(Integer minInclusive) {
            this.minInclusive = minInclusive;
            if (minInclusive > this.maxInclusive) {
                throw new IllegalArgumentException("Can't set min to %d, as it must not be greater than max (%d)".formatted(minInclusive, this.maxInclusive));
            }
            return this;
        }

        public RandomIntBuilder max(Integer maxInclusive) {
            if (maxInclusive < this.minInclusive) {
                throw new IllegalArgumentException("Can't set max to %d, as it must not be less than min (%d)".formatted(maxInclusive, this.minInclusive));
            }
            if (maxInclusive == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Can't set max to %d (Integer.MAX_VALUE)".formatted(maxInclusive));
            }
            this.maxInclusive = maxInclusive;
            return this;
        }

        @Override
        public Integer build() {
            return this.secureRandom.nextInt(this.minInclusive, this.maxInclusive + 1);
        }
    }

    public static class RandomLongBuilder
    implements RandomNumberBuilder<Long> {
        private final SecureRandom secureRandom = new SecureRandom();
        private long minInclusive;
        private long maxInclusive;

        private RandomLongBuilder(long min, long max) {
            this.minInclusive = min;
            this.maxInclusive = max;
        }

        public RandomLongBuilder positive() {
            return this.min(1L).max(0x7FFFFFFFFFFFFFFEL);
        }

        public RandomLongBuilder negative() {
            return this.min(Long.MIN_VALUE).max(-1L);
        }

        public RandomLongBuilder min(Long minInclusive) {
            this.minInclusive = minInclusive;
            if (minInclusive > this.maxInclusive) {
                throw new IllegalArgumentException("Can't set min to %d, as it must not be greater than max (%d)".formatted(minInclusive, this.maxInclusive));
            }
            return this;
        }

        public RandomLongBuilder max(Long maxInclusive) {
            if (maxInclusive < this.minInclusive) {
                throw new IllegalArgumentException("Can't set max to %d, as it must not be less than min (%d)".formatted(maxInclusive, this.minInclusive));
            }
            if (maxInclusive == Long.MAX_VALUE) {
                throw new IllegalArgumentException("Can't set max to %d (Long.MAX_VALUE)".formatted(maxInclusive));
            }
            this.maxInclusive = maxInclusive;
            return this;
        }

        @Override
        public Long build() {
            return this.secureRandom.nextLong(this.minInclusive, this.maxInclusive + 1L);
        }
    }
}

