/*
 * Decompiled with CFR 0.152.
 */
package org.sturrock.cassette.cassettej;

import java.io.IOException;
import java.util.Properties;
import org.sturrock.cassette.cassettej.ContentAddressableStore;
import org.sturrock.cassette.cassettej.ContentAddressableStoreFileImpl;
import org.sturrock.cassette.cassettej.ContentAddressableStoreInfinispanImpl;

public class ContentAddressableStoreFactory {
    public static ContentAddressableStore createContentAddressableStore(ImplementationType implementationType, Properties properties) throws IOException {
        switch (implementationType) {
            case FILE: {
                return new ContentAddressableStoreFileImpl(properties);
            }
            case INFINISPAN: {
                return new ContentAddressableStoreInfinispanImpl(properties);
            }
        }
        throw new IllegalArgumentException("Unknown ContentAddressableStore implementation type: " + implementationType.name());
    }

    public static enum ImplementationType {
        FILE,
        INFINISPAN;

    }
}

