/*
 * Decompiled with CFR 0.152.
 */
package org.sturrock.cassette.cassettej;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.IOUtils;
import org.sturrock.cassette.cassettej.ContentAddressableStoreImpl;
import org.sturrock.cassette.cassettej.ContentEncoding;
import org.sturrock.cassette.cassettej.Hash;

public final class ContentAddressableStoreFileImpl
extends ContentAddressableStoreImpl {
    private final Path rootPath;
    private final int bufferSize = 4096;
    public final int hashPrefixLength = 4;
    public static final String rootPathPropertyName = ContentAddressableStoreFileImpl.class.getName() + ".rootPath";

    public Path getRootPath() {
        return this.rootPath;
    }

    public ContentAddressableStoreFileImpl(Properties properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        String rootPath = properties.getProperty(rootPathPropertyName);
        if (rootPath == null || rootPath.equals("")) {
            throw new IllegalArgumentException("No property " + rootPathPropertyName + " found");
        }
        this.rootPath = Paths.get(rootPath, new String[0]);
        if (!Files.isDirectory(this.rootPath, new LinkOption[0])) {
            Files.createDirectories(this.rootPath, new FileAttribute[0]);
        }
    }

    @Override
    public Hash write(InputStream inputStream) throws IOException {
        return this.write(inputStream, new LinkedList<ContentEncoding>());
    }

    @Override
    public Hash write(InputStream inputStream, List<ContentEncoding> encodings) throws IOException {
        MessageDigest messageDigest;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream");
        }
        if (encodings == null) {
            encodings = new LinkedList<ContentEncoding>();
        }
        Path tmpFile = Files.createTempFile("CassetteJ", ".tmp", new FileAttribute[0]);
        try {
            Files.copy(inputStream, tmpFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            Files.delete(tmpFile);
            throw new IOException(e);
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        try (FileInputStream fileInputStream = new FileInputStream(tmpFile.toFile());){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fileInputStream).read(buffer);
                if (n <= 0) continue;
                messageDigest.update(buffer, 0, n);
            }
        }
        byte[] bytes = messageDigest.digest();
        Hash hash = new Hash(bytes);
        Path contentPath = this.getContentPath(hash.getString());
        Path subPath = this.getSubPath(hash.getString());
        boolean contentAdded = false;
        if (!Files.exists(contentPath, new LinkOption[0])) {
            if (!Files.isDirectory(subPath, new LinkOption[0])) {
                Files.createDirectories(subPath, new FileAttribute[0]);
            }
            Files.move(tmpFile, contentPath, new CopyOption[0]);
            contentAdded = true;
        } else {
            Files.delete(tmpFile);
        }
        for (ContentEncoding encoding : encodings) {
            Path encodedContentPath = this.getContentPath(hash.getString() + "." + encoding.getName());
            if (Files.exists(encodedContentPath, new LinkOption[0])) continue;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(encodedContentPath, new OpenOption[0]));){
                DeflaterOutputStream encodedOutputStream = encoding.encode(outputStream);
                Throwable throwable = null;
                try {
                    InputStream rawContents = Files.newInputStream(contentPath, new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)rawContents, (OutputStream)encodedOutputStream);
                        encodedOutputStream.finish();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rawContents == null) continue;
                        ContentAddressableStoreFileImpl.$closeResource(throwable2, rawContents);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (encodedOutputStream == null) continue;
                    ContentAddressableStoreFileImpl.$closeResource(throwable, encodedOutputStream);
                }
            }
        }
        if (contentAdded) {
            this.notifyListenersContentAdded(hash);
        }
        return hash;
    }

    @Override
    public boolean contains(Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        Path contentPath = this.getContentPath(hash.getString());
        return Files.exists(contentPath, new LinkOption[0]);
    }

    @Override
    public boolean contains(Hash hash, ContentEncoding contentEncoding) {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        if (contentEncoding == null) {
            return this.contains(hash);
        }
        Path encodedContentPath = this.getContentPath(hash.getString() + "." + contentEncoding.getName());
        return Files.exists(encodedContentPath, new LinkOption[0]);
    }

    @Override
    public InputStream read(Hash hash, ContentEncoding contentEncoding) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        if (contentEncoding == null) {
            return this.read(hash);
        }
        Path encodedContentPath = this.getContentPath(hash.getString() + "." + contentEncoding.getName());
        if (!Files.exists(encodedContentPath, new LinkOption[0])) {
            return null;
        }
        return new BufferedInputStream(Files.newInputStream(encodedContentPath, new OpenOption[0]));
    }

    @Override
    public InputStream read(Hash hash) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        Path contentPath = this.getContentPath(hash.getString());
        if (!Files.exists(contentPath, new LinkOption[0])) {
            return null;
        }
        return new BufferedInputStream(Files.newInputStream(contentPath, new OpenOption[0]));
    }

    @Override
    public long getContentLength(Hash hash) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        Path contentPath = this.getContentPath(hash.getString());
        if (!Files.exists(contentPath, new LinkOption[0])) {
            return -1L;
        }
        BasicFileAttributes attrs = Files.readAttributes(contentPath, BasicFileAttributes.class, new LinkOption[0]);
        return attrs.size();
    }

    @Override
    public long getContentLength(Hash hash, ContentEncoding contentEncoding) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        if (contentEncoding == null) {
            return this.getContentLength(hash);
        }
        Path encodedContentPath = this.getContentPath(hash.getString() + "." + contentEncoding.getName());
        if (!Files.exists(encodedContentPath, new LinkOption[0])) {
            return -1L;
        }
        BasicFileAttributes attrs = Files.readAttributes(encodedContentPath, BasicFileAttributes.class, new LinkOption[0]);
        return attrs.size();
    }

    @Override
    public List<Hash> getHashes() throws IOException {
        LinkedList<Hash> hashes = new LinkedList<Hash>();
        try (DirectoryStream<Path> directories = Files.newDirectoryStream(this.rootPath, "[0-9A-F]*");){
            for (Path directory : directories) {
                DirectoryStream<Path> files = Files.newDirectoryStream(directory, "[0-9A-F]*");
                Throwable throwable = null;
                try {
                    for (Path file : files) {
                        if (file.getFileName().toString().contains(".")) continue;
                        Hash hash = new Hash(directory.getFileName().toString() + file.getFileName().toString());
                        hashes.add(hash);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    ContentAddressableStoreFileImpl.$closeResource(throwable, files);
                }
            }
            LinkedList<Hash> linkedList = hashes;
            return linkedList;
        }
    }

    @Override
    public boolean delete(Hash hash) throws IOException {
        Throwable throwable;
        DirectoryStream<Path> stream;
        String hashString = hash.getString();
        Path contentPath = this.getContentPath(hashString);
        if (!Files.exists(contentPath, new LinkOption[0])) {
            return false;
        }
        Path dirPath = this.getSubPath(hashString);
        try {
            stream = Files.newDirectoryStream(dirPath, hashString.substring(4) + "*");
            throwable = null;
            try {
                stream.forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    ContentAddressableStoreFileImpl.$closeResource(throwable, stream);
                }
            }
        }
        catch (UncheckedIOException e) {
            throw e.ioException;
        }
        stream = Files.newDirectoryStream(dirPath);
        throwable = null;
        try {
            if (!stream.iterator().hasNext()) {
                Files.delete(dirPath);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (stream != null) {
                ContentAddressableStoreFileImpl.$closeResource(throwable, stream);
            }
        }
        this.notifyListenersContentRemoved(hash);
        return true;
    }

    public Path getContentPath(String hashString) {
        Path subPath = this.getSubPath(hashString);
        Path contentPath = subPath.resolve(hashString.substring(4));
        return contentPath;
    }

    public Path getSubPath(String hashString) {
        Path subPath = this.rootPath.resolve(hashString.substring(0, 4));
        return subPath;
    }

    @Override
    public void close() {
    }

    private class UncheckedIOException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public IOException ioException;

        public UncheckedIOException(IOException ioException) {
            this.ioException = ioException;
        }
    }
}

