/*
 * Decompiled with CFR 0.152.
 */
package org.sturrock.cassette.cassettej;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.IOUtils;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.sturrock.cassette.cassettej.ContentAddressableStoreImpl;
import org.sturrock.cassette.cassettej.ContentEncoding;
import org.sturrock.cassette.cassettej.Hash;

public class ContentAddressableStoreInfinispanImpl
extends ContentAddressableStoreImpl {
    private DefaultCacheManager cacheManager;
    public static final String configFilePropertyName = ContentAddressableStoreInfinispanImpl.class.getName() + ".configFile";
    public static final String cacheNamePropertyName = ContentAddressableStoreInfinispanImpl.class.getName() + ".cacheName";
    private Cache<Hash, CacheValue> cache;

    public ContentAddressableStoreInfinispanImpl(Properties properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        String configFileName = properties.getProperty(configFilePropertyName);
        if (configFileName == null || configFileName.equals("")) {
            throw new IllegalArgumentException("No property " + configFilePropertyName + " found");
        }
        Path configFile = Paths.get(configFileName, new String[0]);
        if (!Files.isRegularFile(configFile, new LinkOption[0])) {
            throw new IllegalArgumentException("No config file " + configFileName + " found");
        }
        this.cacheManager = new DefaultCacheManager(configFileName, true);
        String cacheName = properties.getProperty(cacheNamePropertyName);
        if (cacheName == null || cacheName.equals("")) {
            throw new IllegalArgumentException("No property " + cacheNamePropertyName + " found");
        }
        this.cache = this.cacheManager.getCache(cacheName);
    }

    @Override
    public Hash write(InputStream inputStream) throws IOException {
        return this.write(inputStream, new LinkedList<ContentEncoding>());
    }

    @Override
    public Hash write(InputStream inputStream, List<ContentEncoding> encodings) throws IOException {
        MessageDigest messageDigest;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream");
        }
        if (encodings == null) {
            encodings = new LinkedList<ContentEncoding>();
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        messageDigest.update(bytes);
        Hash hash = new Hash(messageDigest.digest());
        CacheValue cacheValue = new CacheValue();
        cacheValue.raw = bytes;
        for (ContentEncoding encoding : encodings) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                DeflaterOutputStream encodedOutputStream = encoding.encode(outputStream);
                Throwable throwable = null;
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                    IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)encodedOutputStream);
                    encodedOutputStream.finish();
                    cacheValue.encoded.put(encoding, outputStream.toByteArray());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (encodedOutputStream == null) continue;
                    ContentAddressableStoreInfinispanImpl.$closeResource(throwable, encodedOutputStream);
                }
            }
        }
        CacheValue previous = (CacheValue)this.cache.put((Object)hash, (Object)cacheValue);
        if (previous == null) {
            this.notifyListenersContentAdded(hash);
        }
        return hash;
    }

    @Override
    public boolean contains(Hash hash) {
        return this.cache.containsKey((Object)hash);
    }

    @Override
    public boolean contains(Hash hash, ContentEncoding contentEncoding) {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        if (contentEncoding == null) {
            return this.contains(hash);
        }
        CacheValue cacheValue = (CacheValue)this.cache.get((Object)hash);
        if (cacheValue == null) {
            return false;
        }
        byte[] bytes = cacheValue.encoded.get(contentEncoding);
        return bytes != null;
    }

    @Override
    public InputStream read(Hash hash) throws FileNotFoundException {
        CacheValue cacheValue = (CacheValue)this.cache.get((Object)hash);
        if (cacheValue == null) {
            return null;
        }
        return new ByteArrayInputStream(cacheValue.raw);
    }

    @Override
    public InputStream read(Hash hash, ContentEncoding contentEncoding) throws FileNotFoundException {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        if (contentEncoding == null) {
            return this.read(hash);
        }
        CacheValue cacheValue = (CacheValue)this.cache.get((Object)hash);
        if (cacheValue == null) {
            return null;
        }
        byte[] encoded = cacheValue.encoded.get(contentEncoding);
        if (encoded == null) {
            return null;
        }
        return new ByteArrayInputStream(encoded);
    }

    @Override
    public long getContentLength(Hash hash) throws IOException {
        CacheValue cacheValue = (CacheValue)this.cache.get((Object)hash);
        if (cacheValue == null) {
            return -1L;
        }
        return cacheValue.raw.length;
    }

    @Override
    public long getContentLength(Hash hash, ContentEncoding contentEncoding) throws IOException {
        if (contentEncoding == null) {
            return this.getContentLength(hash);
        }
        CacheValue cacheValue = (CacheValue)this.cache.get((Object)hash);
        if (cacheValue == null) {
            return -1L;
        }
        byte[] encoded = cacheValue.encoded.get(contentEncoding);
        if (encoded == null) {
            return -1L;
        }
        return encoded.length;
    }

    @Override
    public List<Hash> getHashes() throws IOException {
        LinkedList<Hash> hashes = new LinkedList<Hash>();
        hashes.addAll((Collection<Hash>)this.cache.keySet());
        return hashes;
    }

    @Override
    public boolean delete(Hash hash) throws IOException {
        CacheValue contentRemoved = (CacheValue)this.cache.remove((Object)hash);
        if (contentRemoved == null) {
            return false;
        }
        this.notifyListenersContentRemoved(hash);
        return true;
    }

    @Override
    public void close() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
        this.cacheManager = null;
    }

    private class CacheValue {
        public byte[] raw;
        public Map<ContentEncoding, byte[]> encoded = new HashMap<ContentEncoding, byte[]>();

        private CacheValue() {
        }
    }
}

