/*
 * Decompiled with CFR 0.152.
 */
package org.sturrock.cassette.cassettej;

import java.util.Arrays;
import java.util.Formatter;

public final class Hash {
    public static final int byteCount = 20;
    private String string;
    private byte[] bytes;

    public Hash(String string) {
        this.string = new String(string);
        this.bytes = Hash.getBytes(this.string);
    }

    public Hash(byte[] bytes) {
        this.bytes = Arrays.copyOf(bytes, bytes.length);
        this.string = Hash.getString(this.bytes);
    }

    public String getString() {
        return new String(this.string);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public static String getString(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02X", b);
        }
        String hashString = formatter.toString();
        formatter.close();
        return hashString;
    }

    public static byte[] getBytes(String string) {
        int len = string.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean equals(byte[] hash1, byte[] hash2) {
        if (hash1 == null) {
            throw new IllegalArgumentException("hash1");
        }
        if (hash2 == null) {
            throw new IllegalArgumentException("hash2");
        }
        if (hash1.length != 20) {
            throw new IllegalArgumentException("hash1 has invalid length.");
        }
        if (hash2.length != 20) {
            throw new IllegalArgumentException("hash2 hHas invalid length.");
        }
        for (int i = 0; i < 20; ++i) {
            if (hash1[i] == hash2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hash other = (Hash)obj;
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }
}

