/*
 * Decompiled with CFR 0.152.
 */
package spray.can.websocket.frame;

import akka.util.ByteIterator;
import akka.util.ByteString$;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import spray.can.websocket.frame.Frame;
import spray.can.websocket.frame.Frame$;
import spray.can.websocket.frame.FrameParser$;
import spray.can.websocket.frame.FrameParser$ExpectFin$;
import spray.can.websocket.frame.FrameParser$ExpectLongPayloadLen$;
import spray.can.websocket.frame.FrameParser$ExpectMasked$;
import spray.can.websocket.frame.FrameParser$ExpectMaskingKey$;
import spray.can.websocket.frame.FrameParser$ExpectPayloadLen$;
import spray.can.websocket.frame.FrameParser$ExpectShortPayloadLen$;
import spray.can.websocket.frame.FrameParser$FalseFinControlFrame$;
import spray.can.websocket.frame.FrameParser$InvalidOpcode$;
import spray.can.websocket.frame.FrameParser$OversizedControlFrame$;
import spray.can.websocket.frame.FrameParser$OversizedDataFrame$;
import spray.can.websocket.frame.Opcode$;

@ScalaSignature(bytes="\u0006\u0001\u0011Uv!B\u0001\u0003\u0011\u0003Y\u0011a\u0003$sC6,\u0007+\u0019:tKJT!a\u0001\u0003\u0002\u000b\u0019\u0014\u0018-\\3\u000b\u0005\u00151\u0011!C<fEN|7m[3u\u0015\t9\u0001\"A\u0002dC:T\u0011!C\u0001\u0006gB\u0014\u0018-_\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005-1%/Y7f!\u0006\u00148/\u001a:\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9!$\u0004a\u0001\n\u0003Y\u0012A\u00044sC6,7+\u001b>f\u0019&l\u0017\u000e^\u000b\u00029A\u0011\u0011#H\u0005\u0003=I\u0011A\u0001T8oO\"9\u0001%\u0004a\u0001\n\u0003\t\u0013A\u00054sC6,7+\u001b>f\u0019&l\u0017\u000e^0%KF$\"AI\u0013\u0011\u0005E\u0019\u0013B\u0001\u0013\u0013\u0005\u0011)f.\u001b;\t\u000f\u0019z\u0012\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\r!j\u0001\u0015)\u0003\u001d\u0003=1'/Y7f'&TX\rT5nSR\u0004ca\u0002\u0016\u000e!\u0003\r\nc\u000b\u0002\u0006'R\fG/Z\n\u0003SAAQ!L\u0015\u0007\u0002m\taA\u001c\"zi\u0016\u001c\u0018FD\u00150\u0003\u0013\tI$a\u0018\u0002\u0018\u00065(q\u0017\u0004\u0005a5\u0011\u0015G\u0001\u0006FqB,7\r\u001e#bi\u0006\u001cRa\f\t3i]\u0002\"aM\u0015\u000e\u00035\u0001\"!E\u001b\n\u0005Y\u0012\"a\u0002)s_\u0012,8\r\u001e\t\u0003#aJ!!\u000f\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u00115z#Q3A\u0005\u0002mA\u0001\u0002P\u0018\u0003\u0012\u0003\u0006I\u0001H\u0001\b]\nKH/Z:!\u0011\u00159r\u0006\"\u0001?)\ty\u0004\t\u0005\u00024_!)Q&\u0010a\u00019!9!iLA\u0001\n\u0003\u0019\u0015\u0001B2paf$\"a\u0010#\t\u000f5\n\u0005\u0013!a\u00019!9aiLI\u0001\n\u00039\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u0011*\u0012A$S\u0016\u0002\u0015B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0014\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002R\u0019\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fM{\u0013\u0011!C!)\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA\u0001\\1oO*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005\u0019\u0019FO]5oO\"9alLA\u0001\n\u0003y\u0016\u0001\u00049s_\u0012,8\r^!sSRLX#\u00011\u0011\u0005E\t\u0017B\u00012\u0013\u0005\rIe\u000e\u001e\u0005\bI>\n\t\u0011\"\u0001f\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"AZ5\u0011\u0005E9\u0017B\u00015\u0013\u0005\r\te.\u001f\u0005\bM\r\f\t\u00111\u0001a\u0011\u001dYw&!A\u0005B1\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002[B\u0019a.\u001d4\u000e\u0003=T!\u0001\u001d\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002s_\nA\u0011\n^3sCR|'\u000fC\u0004u_\u0005\u0005I\u0011A;\u0002\u0011\r\fg.R9vC2$\"A^=\u0011\u0005E9\u0018B\u0001=\u0013\u0005\u001d\u0011un\u001c7fC:DqAJ:\u0002\u0002\u0003\u0007a\rC\u0004|_\u0005\u0005I\u0011\t?\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u0019\u0005\b}>\n\t\u0011\"\u0011\u0000\u0003!!xn\u0015;sS:<G#A+\t\u0013\u0005\rq&!A\u0005B\u0005\u0015\u0011AB3rk\u0006d7\u000fF\u0002w\u0003\u000fA\u0001BJA\u0001\u0003\u0003\u0005\rA\u001a\u0004\b\u0003\u0017i\u0001\u0012QA\u0007\u0005%)\u0005\u0010]3di\u001aKgn\u0005\u0004\u0002\nA\u0011Dg\u000e\u0005\b/\u0005%A\u0011AA\t)\t\t\u0019\u0002E\u00024\u0003\u0013Aa!LA\u0005\t\u0003Y\u0002\u0002C*\u0002\n\u0005\u0005I\u0011\t+\t\u0011y\u000bI!!A\u0005\u0002}C\u0011\u0002ZA\u0005\u0003\u0003%\t!!\b\u0015\u0007\u0019\fy\u0002\u0003\u0005'\u00037\t\t\u00111\u0001a\u0011!Y\u0017\u0011BA\u0001\n\u0003b\u0007\"\u0003;\u0002\n\u0005\u0005I\u0011AA\u0013)\r1\u0018q\u0005\u0005\tM\u0005\r\u0012\u0011!a\u0001M\"A10!\u0003\u0002\u0002\u0013\u0005C\u0010\u0003\u0005\u007f\u0003\u0013\t\t\u0011\"\u0011\u0000\u0011)\ty#!\u0003\u0002\u0002\u0013%\u0011\u0011G\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00024A\u0019a+!\u000e\n\u0007\u0005]rK\u0001\u0004PE*,7\r\u001e\u0004\b\u0003wi\u0001\u0012QA\u001f\u00051)\u0005\u0010]3di6\u000b7o[3e'\u0019\tI\u0004\u0005\u001a5o!9q#!\u000f\u0005\u0002\u0005\u0005CCAA\"!\r\u0019\u0014\u0011\b\u0005\u0007[\u0005eB\u0011A\u000e\t\u0011M\u000bI$!A\u0005BQC\u0001BXA\u001d\u0003\u0003%\ta\u0018\u0005\nI\u0006e\u0012\u0011!C\u0001\u0003\u001b\"2AZA(\u0011!1\u00131JA\u0001\u0002\u0004\u0001\u0007\u0002C6\u0002:\u0005\u0005I\u0011\t7\t\u0013Q\fI$!A\u0005\u0002\u0005UCc\u0001<\u0002X!Aa%a\u0015\u0002\u0002\u0003\u0007a\r\u0003\u0005|\u0003s\t\t\u0011\"\u0011}\u0011!q\u0018\u0011HA\u0001\n\u0003z\bBCA\u0018\u0003s\t\t\u0011\"\u0003\u00022\u00199\u0011\u0011M\u0007\t\u0002\u0006\r$\u0001E#ya\u0016\u001cG/T1tW&twmS3z'\u0019\ty\u0006\u0005\u001a5o!9q#a\u0018\u0005\u0002\u0005\u001dDCAA5!\r\u0019\u0014q\f\u0005\u0007[\u0005}C\u0011A\u000e\t\u0011\u0005=\u0014q\fC\u0001\u0003c\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002t\u0005e\u0004\u0003B\t\u0002vqI1!a\u001e\u0013\u0005\u0019y\u0005\u000f^5p]\"A\u00111PA7\u0001\u0004\ti(A\u0001y\u001b\t\ty\u0006\u0003\u0005T\u0003?\n\t\u0011\"\u0011U\u0011!q\u0016qLA\u0001\n\u0003y\u0006\"\u00033\u0002`\u0005\u0005I\u0011AAC)\r1\u0017q\u0011\u0005\tM\u0005\r\u0015\u0011!a\u0001A\"A1.a\u0018\u0002\u0002\u0013\u0005C\u000eC\u0005u\u0003?\n\t\u0011\"\u0001\u0002\u000eR\u0019a/a$\t\u0011\u0019\nY)!AA\u0002\u0019D\u0001b_A0\u0003\u0003%\t\u0005 \u0005\t}\u0006}\u0013\u0011!C!\u007f\"Q\u0011qFA0\u0003\u0003%I!!\r\u0007\u0013\u0005eU\u0002%A\u0012\"\u0005m%\u0001E#ya\u0016\u001cG\u000fU1zY>\fG\rT3o'\u0011\t9\n\u0005\u001a*\r\u0005]\u0015qTAd\r\u001d\t\t+\u0004EA\u0003G\u0013A#\u0012=qK\u000e$Hj\u001c8h!\u0006LHn\\1e\u0019\u0016t7cBAP!\u0005\u0015Fg\u000e\t\u0004g\u0005]\u0005bB\f\u0002 \u0012\u0005\u0011\u0011\u0016\u000b\u0003\u0003W\u00032aMAP\u0011\u0019i\u0013q\u0014C\u00017!A1+a(\u0002\u0002\u0013\u0005C\u000b\u0003\u0005_\u0003?\u000b\t\u0011\"\u0001`\u0011%!\u0017qTA\u0001\n\u0003\t)\fF\u0002g\u0003oC\u0001BJAZ\u0003\u0003\u0005\r\u0001\u0019\u0005\tW\u0006}\u0015\u0011!C!Y\"IA/a(\u0002\u0002\u0013\u0005\u0011Q\u0018\u000b\u0004m\u0006}\u0006\u0002\u0003\u0014\u0002<\u0006\u0005\t\u0019\u00014\t\u0011m\fy*!A\u0005BqD\u0001B`AP\u0003\u0003%\te \u0005\u000b\u0003_\ty*!A\u0005\n\u0005EbaBAe\u001b!\u0005\u00151\u001a\u0002\u0016\u000bb\u0004Xm\u0019;TQ>\u0014H\u000fU1zY>\fG\rT3o'\u001d\t9\rEASi]BqaFAd\t\u0003\ty\r\u0006\u0002\u0002RB\u00191'a2\t\r5\n9\r\"\u0001\u001c\u0011!\u0019\u0016qYA\u0001\n\u0003\"\u0006\u0002\u00030\u0002H\u0006\u0005I\u0011A0\t\u0013\u0011\f9-!A\u0005\u0002\u0005mGc\u00014\u0002^\"Aa%!7\u0002\u0002\u0003\u0007\u0001\r\u0003\u0005l\u0003\u000f\f\t\u0011\"\u0011m\u0011%!\u0018qYA\u0001\n\u0003\t\u0019\u000fF\u0002w\u0003KD\u0001BJAq\u0003\u0003\u0005\rA\u001a\u0005\tw\u0006\u001d\u0017\u0011!C!y\"Aa0a2\u0002\u0002\u0013\u0005s\u0010\u0003\u0006\u00020\u0005\u001d\u0017\u0011!C\u0005\u0003c1q!a<\u000e\u0003C\t\tPA\u0004GC&dWO]3\u0014\t\u00055\bC\r\u0005\f\u0003k\fiO!b\u0001\n\u0003\t90\u0001\u0006ti\u0006$Xo]\"pI\u0016,\"!!?\u0011\u00071\tY0C\u0002\u0002~\n\u0011!b\u0015;biV\u001c8i\u001c3f\u0011-\u0011\t!!<\u0003\u0002\u0003\u0006I!!?\u0002\u0017M$\u0018\r^;t\u0007>$W\r\t\u0005\f\u0005\u000b\tiO!b\u0001\n\u0003\u00119!\u0001\u0004sK\u0006\u001cxN\\\u000b\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00129\u0019\u0011C!\u0004\n\u0007\t=!#\u0001\u0004Qe\u0016$WMZ\u0005\u00049\nM!b\u0001B\b%!Y!qCAw\u0005\u0003\u0005\u000b\u0011\u0002B\u0005\u0003\u001d\u0011X-Y:p]\u0002BqaFAw\t\u0003\u0011Y\u0002\u0006\u0004\u0003\u001e\t}!\u0011\u0005\t\u0004g\u00055\b\u0002CA{\u00053\u0001\r!!?\t\u0011\t\u0015!\u0011\u0004a\u0001\u0005\u0013Aa!LAw\t\u0003Y\u0012FCAw\u0005O\u0011YEa\u001c\u0003\u0014\u001a9!\u0011F\u0007\t\u0002\n-\"\u0001\u0006$bYN,g)\u001b8D_:$(o\u001c7Ge\u0006lWm\u0005\u0004\u0003(\tuAg\u000e\u0005\b/\t\u001dB\u0011\u0001B\u0018)\t\u0011\t\u0004E\u00024\u0005OA\u0001b\u0015B\u0014\u0003\u0003%\t\u0005\u0016\u0005\t=\n\u001d\u0012\u0011!C\u0001?\"IAMa\n\u0002\u0002\u0013\u0005!\u0011\b\u000b\u0004M\nm\u0002\u0002\u0003\u0014\u00038\u0005\u0005\t\u0019\u00011\t\u0011-\u00149#!A\u0005B1D\u0011\u0002\u001eB\u0014\u0003\u0003%\tA!\u0011\u0015\u0007Y\u0014\u0019\u0005\u0003\u0005'\u0005\u007f\t\t\u00111\u0001g\u0011!Y(qEA\u0001\n\u0003b\b\u0002\u0003@\u0003(\u0005\u0005I\u0011I@\t\u0015\u0005=\"qEA\u0001\n\u0013\t\tDB\u0004\u0003N5A\tIa\u0014\u0003\u001b%sg/\u00197jI>\u00038m\u001c3f'\u0019\u0011YE!\b5o!9qCa\u0013\u0005\u0002\tMCC\u0001B+!\r\u0019$1\n\u0005\t'\n-\u0013\u0011!C!)\"AaLa\u0013\u0002\u0002\u0013\u0005q\fC\u0005e\u0005\u0017\n\t\u0011\"\u0001\u0003^Q\u0019aMa\u0018\t\u0011\u0019\u0012Y&!AA\u0002\u0001D\u0001b\u001bB&\u0003\u0003%\t\u0005\u001c\u0005\ni\n-\u0013\u0011!C\u0001\u0005K\"2A\u001eB4\u0011!1#1MA\u0001\u0002\u00041\u0007\u0002C>\u0003L\u0005\u0005I\u0011\t?\t\u0011y\u0014Y%!A\u0005B}D!\"a\f\u0003L\u0005\u0005I\u0011BA\u0019\r\u001d\u0011\t(\u0004EA\u0005g\u0012Qc\u0014<feNL'0\u001a3D_:$(o\u001c7Ge\u0006lWm\u0005\u0004\u0003p\tuAg\u000e\u0005\b/\t=D\u0011\u0001B<)\t\u0011I\bE\u00024\u0005_B\u0001b\u0015B8\u0003\u0003%\t\u0005\u0016\u0005\t=\n=\u0014\u0011!C\u0001?\"IAMa\u001c\u0002\u0002\u0013\u0005!\u0011\u0011\u000b\u0004M\n\r\u0005\u0002\u0003\u0014\u0003\u0000\u0005\u0005\t\u0019\u00011\t\u0011-\u0014y'!A\u0005B1D\u0011\u0002\u001eB8\u0003\u0003%\tA!#\u0015\u0007Y\u0014Y\t\u0003\u0005'\u0005\u000f\u000b\t\u00111\u0001g\u0011!Y(qNA\u0001\n\u0003b\b\u0002\u0003@\u0003p\u0005\u0005I\u0011I@\t\u0015\u0005=\"qNA\u0001\n\u0013\t\tDB\u0004\u0003\u00166A\tIa&\u0003%=3XM]:ju\u0016$G)\u0019;b\rJ\fW.Z\n\u0007\u0005'\u0013i\u0002N\u001c\t\u000f]\u0011\u0019\n\"\u0001\u0003\u001cR\u0011!Q\u0014\t\u0004g\tM\u0005\u0002C*\u0003\u0014\u0006\u0005I\u0011\t+\t\u0011y\u0013\u0019*!A\u0005\u0002}C\u0011\u0002\u001aBJ\u0003\u0003%\tA!*\u0015\u0007\u0019\u00149\u000b\u0003\u0005'\u0005G\u000b\t\u00111\u0001a\u0011!Y'1SA\u0001\n\u0003b\u0007\"\u0003;\u0003\u0014\u0006\u0005I\u0011\u0001BW)\r1(q\u0016\u0005\tM\t-\u0016\u0011!a\u0001M\"A1Pa%\u0002\u0002\u0013\u0005C\u0010\u0003\u0005\u007f\u0005'\u000b\t\u0011\"\u0011\u0000\u0011)\tyCa%\u0002\u0002\u0013%\u0011\u0011\u0007\u0004\u0007\u0005sk!Ia/\u0003\u000fM+8mY3tgN1!q\u0017\t3i]B!b\u0001B\\\u0005+\u0007I\u0011\u0001B`+\t\u0011\t\rE\u0002\r\u0005\u0007L1A!2\u0003\u0005\u00151%/Y7f\u0011-\u0011IMa.\u0003\u0012\u0003\u0006IA!1\u0002\r\u0019\u0014\u0018-\\3!\u0011\u001d9\"q\u0017C\u0001\u0005\u001b$BAa4\u0003RB\u00191Ga.\t\u000f\r\u0011Y\r1\u0001\u0003B\"1QFa.\u0005\u0002mA\u0011B\u0011B\\\u0003\u0003%\tAa6\u0015\t\t='\u0011\u001c\u0005\n\u0007\tU\u0007\u0013!a\u0001\u0005\u0003D\u0011B\u0012B\\#\u0003%\tA!8\u0016\u0005\t}'f\u0001Ba\u0013\"A1Ka.\u0002\u0002\u0013\u0005C\u000b\u0003\u0005_\u0005o\u000b\t\u0011\"\u0001`\u0011%!'qWA\u0001\n\u0003\u00119\u000fF\u0002g\u0005SD\u0001B\nBs\u0003\u0003\u0005\r\u0001\u0019\u0005\tW\n]\u0016\u0011!C!Y\"IAOa.\u0002\u0002\u0013\u0005!q\u001e\u000b\u0004m\nE\b\u0002\u0003\u0014\u0003n\u0006\u0005\t\u0019\u00014\t\u0011m\u00149,!A\u0005BqD\u0001B B\\\u0003\u0003%\te \u0005\u000b\u0003\u0007\u00119,!A\u0005B\teHc\u0001<\u0003|\"AaEa>\u0002\u0002\u0003\u0007amB\u0004\u0003\u00006A\t)a\u0005\u0002\u0013\u0015C\b/Z2u\r&twaBB\u0002\u001b!\u0005\u00151I\u0001\r\u000bb\u0004Xm\u0019;NCN\\W\rZ\u0004\b\u0007\u000fi\u0001\u0012AB\u0005\u0003A)\u0005\u0010]3diB\u000b\u0017\u0010\\8bI2+g\u000eE\u00024\u0007\u00171q!!'\u000e\u0011\u0003\u0019iaE\u0002\u0004\fAAqaFB\u0006\t\u0003\u0019\t\u0002\u0006\u0002\u0004\n!A\u0011qNB\u0006\t\u0003\u0019)\u0002\u0006\u0003\u0002t\r]\u0001\u0002CA>\u0007'\u0001\r!!*\b\u000f\rmQ\u0002#!\u0002R\u0006)R\t\u001f9fGR\u001c\u0006n\u001c:u!\u0006LHn\\1e\u0019\u0016twaBB\u0010\u001b!\u0005\u00151V\u0001\u0015\u000bb\u0004Xm\u0019;M_:<\u0007+Y=m_\u0006$G*\u001a8\b\u000f\r\rR\u0002#!\u0002j\u0005\u0001R\t\u001f9fGRl\u0015m]6j]\u001e\\U-_\u0004\n\u0007Oi\u0011\u0011!E\u0001\u0007S\t!\"\u0012=qK\u000e$H)\u0019;b!\r\u001941\u0006\u0004\ta5\t\t\u0011#\u0001\u0004.M)11FB\u0018oA11\u0011GB\u001c9}j!aa\r\u000b\u0007\rU\"#A\u0004sk:$\u0018.\\3\n\t\re21\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004bB\f\u0004,\u0011\u00051Q\b\u000b\u0003\u0007SA\u0001B`B\u0016\u0003\u0003%)e \u0005\u000b\u0007\u0007\u001aY#!A\u0005\u0002\u000e\u0015\u0013!B1qa2LHcA \u0004H!1Qf!\u0011A\u0002qA!\"a\u001c\u0004,\u0005\u0005I\u0011QB&)\u0011\t\u0019h!\u0014\t\u0013\r=3\u0011JA\u0001\u0002\u0004y\u0014a\u0001=%a!Q\u0011qFB\u0016\u0003\u0003%I!!\r\b\u0013\rUS\"!A\t\u0002\r]\u0013aB*vG\u000e,7o\u001d\t\u0004g\rec!\u0003B]\u001b\u0005\u0005\t\u0012AB.'\u0015\u0019If!\u00188!!\u0019\tda\u000e\u0003B\n=\u0007bB\f\u0004Z\u0011\u00051\u0011\r\u000b\u0003\u0007/B\u0001B`B-\u0003\u0003%)e \u0005\u000b\u0007\u0007\u001aI&!A\u0005\u0002\u000e\u001dD\u0003\u0002Bh\u0007SBqaAB3\u0001\u0004\u0011\t\r\u0003\u0006\u0002p\re\u0013\u0011!CA\u0007[\"Baa\u001c\u0004rA)\u0011#!\u001e\u0003B\"Q1qJB6\u0003\u0003\u0005\rAa4\t\u0015\u0005=2\u0011LA\u0001\n\u0013\t\tdB\u0004\u0004x5A\ta!\u001f\u0002\u000f\u0019\u000b\u0017\u000e\\;sKB\u00191ga\u001f\u0007\u000f\u0005=X\u0002#\u0001\u0004~M\u001911\u0010\t\t\u000f]\u0019Y\b\"\u0001\u0004\u0002R\u00111\u0011\u0010\u0005\t\u0003_\u001aY\b\"\u0001\u0004\u0006R!1qQBH!\u0015\t\u0012QOBE!\u001d\t21RA}\u0005\u0013I1a!$\u0013\u0005\u0019!V\u000f\u001d7fe!A\u00111PBB\u0001\u0004\u0011ibB\u0004\u0004\u00146A\tI!\u0016\u0002\u001b%sg/\u00197jI>\u00038m\u001c3f\u000f\u001d\u00199*\u0004EA\u0005c\tACR1mg\u00164\u0015N\\\"p]R\u0014x\u000e\u001c$sC6,waBBN\u001b!\u0005%\u0011P\u0001\u0016\u001fZ,'o]5{K\u0012\u001cuN\u001c;s_24%/Y7f\u000f\u001d\u0019y*\u0004EA\u0005;\u000b!c\u0014<feNL'0\u001a3ECR\fgI]1nK\u001a)aB\u0001\u0002\u0004$N\u00191\u0011\u0015\t\t\u000f]\u0019\t\u000b\"\u0001\u0004(R\u00111\u0011\u0016\t\u0004\u0019\r\u0005\u0006\u0002DBW\u0007C\u0003\r\u00111A\u0005\n\r=\u0016\u0001\u00034j]J\u001bho\u00149\u0016\u0005\rE\u0006cA\t\u00044&\u00191Q\u0017\n\u0003\t\tKH/\u001a\u0005\r\u0007s\u001b\t\u000b1AA\u0002\u0013%11X\u0001\rM&t'k\u001d<Pa~#S-\u001d\u000b\u0004E\ru\u0006\"\u0003\u0014\u00048\u0006\u0005\t\u0019ABY\u0011%\u0019\tm!)!B\u0013\u0019\t,A\u0005gS:\u00146O^(qA!a1QYBQ\u0001\u0004\u0005\r\u0011\"\u0003\u0004H\u0006\u0019a-\u001b8\u0016\u0003YDAba3\u0004\"\u0002\u0007\t\u0019!C\u0005\u0007\u001b\fqAZ5o?\u0012*\u0017\u000fF\u0002#\u0007\u001fD\u0001BJBe\u0003\u0003\u0005\rA\u001e\u0005\t\u0007'\u001c\t\u000b)Q\u0005m\u0006!a-\u001b8!\u00111\u00199n!)A\u0002\u0003\u0007I\u0011BBm\u0003\u0019y\u0007oY8eKV\u001111\u001c\t\u0004\u0019\ru\u0017bABp\u0005\t1q\n]2pI\u0016DAba9\u0004\"\u0002\u0007\t\u0019!C\u0005\u0007K\f!b\u001c9d_\u0012,w\fJ3r)\r\u00113q\u001d\u0005\nM\r\u0005\u0018\u0011!a\u0001\u00077D\u0011ba;\u0004\"\u0002\u0006Kaa7\u0002\u000f=\u00048m\u001c3fA!a1q^BQ\u0001\u0004\u0005\r\u0011\"\u0003\u0004H\u0006A\u0011n]'bg.,G\r\u0003\u0007\u0004t\u000e\u0005\u0006\u0019!a\u0001\n\u0013\u0019)0\u0001\u0007jg6\u000b7o[3e?\u0012*\u0017\u000fF\u0002#\u0007oD\u0001BJBy\u0003\u0003\u0005\rA\u001e\u0005\t\u0007w\u001c\t\u000b)Q\u0005m\u0006I\u0011n]'bg.,G\r\t\u0005\u000b\u0007\u007f\u001c\t\u000b1A\u0005\n\u0011\u0005\u0011AC7bg.LgnZ&fsV\u0011A1\u0001\t\u0006#\u0011\u00151\u0011W\u0005\u0004\t\u000f\u0011\"!B!se\u0006L\bB\u0003C\u0006\u0007C\u0003\r\u0011\"\u0003\u0005\u000e\u0005qQ.Y:lS:<7*Z=`I\u0015\fHc\u0001\u0012\u0005\u0010!Ia\u0005\"\u0003\u0002\u0002\u0003\u0007A1\u0001\u0005\n\t'\u0019\t\u000b)Q\u0005\t\u0007\t1\"\\1tW&twmS3zA!YAqCBQ\u0001\u0004\u0005\r\u0011\"\u0003\u001c\u0003)\u0001\u0018-\u001f7pC\u0012dUM\u001c\u0005\r\t7\u0019\t\u000b1AA\u0002\u0013%AQD\u0001\u000fa\u0006LHn\\1e\u0019\u0016tw\fJ3r)\r\u0011Cq\u0004\u0005\tM\u0011e\u0011\u0011!a\u00019!AA1EBQA\u0003&A$A\u0006qCfdw.\u00193MK:\u0004\u0003B\u0003C\u0014\u0007C\u0003\r\u0011\"\u0003\u0005*\u0005)1\u000f^1uKV\u0011A1\u0006\t\u0004\t[IcB\u0001\u0007\u0001\u0011)!\td!)A\u0002\u0013%A1G\u0001\ngR\fG/Z0%KF$2A\tC\u001b\u0011%1CqFA\u0001\u0002\u0004!Y\u0003C\u0005\u0005:\r\u0005\u0006\u0015)\u0003\u0005,\u000511\u000f^1uK\u0002B!\u0002\"\u0010\u0004\"\u0002\u0007I\u0011\u0002C \u0003\u0015Ig\u000e];u+\t!\t\u0005\u0005\u0003\u0005D\u00115SB\u0001C#\u0015\u0011!9\u0005\"\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003\t\u0017\nA!Y6lC&!Aq\nC#\u00051\u0011\u0015\u0010^3Ji\u0016\u0014\u0018\r^8s\u0011)!\u0019f!)A\u0002\u0013%AQK\u0001\nS:\u0004X\u000f^0%KF$2A\tC,\u0011%1C\u0011KA\u0001\u0002\u0004!\t\u0005C\u0005\u0005\\\r\u0005\u0006\u0015)\u0003\u0005B\u00051\u0011N\u001c9vi\u0002B\u0001\u0002b\u0018\u0004\"\u0012%A\u0011M\u0001\u0007G>t7-\u0019;\u0015\r\u0011\u0005C1\rC4\u0011!!)\u0007\"\u0018A\u0002\u0011\u0005\u0013\u0001\u00027fMRD\u0001\u0002\"\u001b\u0005^\u0001\u0007A\u0011I\u0001\u0006e&<\u0007\u000e\u001e\u0005\t\t[\u001a\t\u000b\"\u0001\u0005p\u0005IqN\u001c*fG\u0016Lg/\u001a\u000b\u0005\tc\"i\bF\u0002#\tgB\u0001\u0002\"\u001e\u0005l\u0001\u0007AqO\u0001\u0005K6LG\u000f\u0005\u0004\u0012\ts\"YCI\u0005\u0004\tw\u0012\"a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\t\u0011\u0011}D1\u000ea\u0001\t\u0003\n\u0001B\\3x\u0013:\u0004X\u000f\u001e\u0005\t\t\u0007\u001b\t\u000b\"\u0003\u0005\u0006\u00069\u0001O]8dKN\u001cHC\u0001CD)\r\u0011C\u0011\u0012\u0005\t\tk\"\t\t1\u0001\u0005x!\"A\u0011\u0011CG!\u0011!y\t\"%\u000e\u00039K1\u0001b%O\u0005\u001d!\u0018-\u001b7sK\u000eD\u0001\u0002b&\u0004\"\u0012%A\u0011T\u0001\u0006a\u0006\u00148/\u001a\u000b\u0007\tW!Y\n\"(\t\u0011\u0011uBQ\u0013a\u0001\t\u0003B\u0001\u0002b\n\u0005\u0016\u0002\u0007A1\u0006\u0005\t\tC\u001b\t\u000b\"\u0003\u0005$\u0006y\u0001/\u0019:tKB\u000b\u0017\u0010\\8bI2+g\u000e\u0006\u0005\u0005,\u0011\u0015Fq\u0015CU\u0011!!i\u0004b(A\u0002\u0011\u0005\u0003BB\u0017\u0005 \u0002\u0007A\u0004C\u0005\u0005,\u0012}\u0005\u0013!a\u0001A\u0006\u0019A.\u001a8\t\u0015\u0011=6\u0011UI\u0001\n\u0013!\t,A\rqCJ\u001cX\rU1zY>\fG\rT3oI\u0011,g-Y;mi\u0012\u001aTC\u0001CZU\t\u0001\u0017\n")
public final class FrameParser {
    private byte finRsvOp;
    private boolean fin;
    private byte opcode;
    private boolean isMasked;
    private byte[] maskingKey = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    private long payloadLen;
    private State state = FrameParser$ExpectFin$.MODULE$;
    private ByteIterator input = ByteString$.MODULE$.empty().iterator();

    public static void frameSizeLimit_$eq(long l) {
        FrameParser$.MODULE$.frameSizeLimit_$eq(l);
    }

    public static long frameSizeLimit() {
        return FrameParser$.MODULE$.frameSizeLimit();
    }

    private byte finRsvOp() {
        return this.finRsvOp;
    }

    private void finRsvOp_$eq(byte x$1) {
        this.finRsvOp = x$1;
    }

    private boolean fin() {
        return this.fin;
    }

    private void fin_$eq(boolean x$1) {
        this.fin = x$1;
    }

    private byte opcode() {
        return this.opcode;
    }

    private void opcode_$eq(byte x$1) {
        this.opcode = x$1;
    }

    private boolean isMasked() {
        return this.isMasked;
    }

    private void isMasked_$eq(boolean x$1) {
        this.isMasked = x$1;
    }

    private byte[] maskingKey() {
        return this.maskingKey;
    }

    private void maskingKey_$eq(byte[] x$1) {
        this.maskingKey = x$1;
    }

    private long payloadLen() {
        return this.payloadLen;
    }

    private void payloadLen_$eq(long x$1) {
        this.payloadLen = x$1;
    }

    private State state() {
        return this.state;
    }

    private void state_$eq(State x$1) {
        this.state = x$1;
    }

    private ByteIterator input() {
        return this.input;
    }

    private void input_$eq(ByteIterator x$1) {
        this.input = x$1;
    }

    private ByteIterator concat(ByteIterator left, ByteIterator right) {
        ByteIterator byteIterator;
        if (right.len() == 0) {
            byteIterator = left;
        } else {
            int leftLen = left.len();
            if (leftLen == 0) {
                byteIterator = right;
            } else {
                int rightLen = right.len();
                byte[] bytes = (byte[])Array$.MODULE$.ofDim(leftLen + rightLen, ClassTag$.MODULE$.Byte());
                left.copyToArray((Object)bytes, 0, leftLen);
                right.copyToArray((Object)bytes, leftLen, rightLen);
                byteIterator = ByteString$.MODULE$.apply(bytes).iterator();
            }
        }
        return byteIterator;
    }

    public void onReceive(ByteIterator newInput, PartialFunction<State, BoxedUnit> emit) {
        this.input_$eq(this.concat(this.input(), newInput));
        this.process(emit);
    }

    private void process(PartialFunction<State, BoxedUnit> emit) {
        do {
            ExpectData expectData;
            long l;
            BoxedUnit boxedUnit;
            if ((long)this.input().len() < this.state().nBytes()) {
                return;
            }
            State state = this.parse(this.input(), this.state());
            if (state instanceof Failure) {
                Failure failure = (Failure)state;
                this.input_$eq(ByteString$.MODULE$.empty().iterator());
                this.state_$eq(FrameParser$ExpectFin$.MODULE$);
                boxedUnit = (BoxedUnit)emit.apply((Object)failure);
                continue;
            }
            if (state instanceof Success) {
                Success success = (Success)state;
                this.state_$eq(FrameParser$ExpectFin$.MODULE$);
                boxedUnit = (BoxedUnit)emit.apply((Object)success);
                continue;
            }
            if (state instanceof ExpectData && 0L == (l = (expectData = (ExpectData)state).nBytes())) {
                this.state_$eq(FrameParser$ExpectFin$.MODULE$);
                boxedUnit = (BoxedUnit)emit.apply((Object)new Success(Frame$.MODULE$.apply(this.finRsvOp(), ByteString$.MODULE$.empty())));
                continue;
            }
            this.state_$eq(state);
            boxedUnit = BoxedUnit.UNIT;
        } while (this.input().hasNext());
    }

    private State parse(ByteIterator input, State state) {
        FrameParser$ExpectMaskingKey$ frameParser$ExpectMaskingKey$;
        Option<Object> option;
        ExpectPayloadLen expectPayloadLen;
        Option<Object> option2;
        State state2;
        State state3 = state;
        if (FrameParser$ExpectFin$.MODULE$.equals(state3)) {
            this.finRsvOp_$eq(input.next());
            this.fin_$eq(Frame$.MODULE$.finFrom(this.finRsvOp()));
            this.opcode_$eq(Frame$.MODULE$.opcodeFrom(this.finRsvOp()));
            state2 = Opcode$.MODULE$.isInvalid$extension(this.opcode()) || Opcode$.MODULE$.isReserved$extension(this.opcode()) ? FrameParser$InvalidOpcode$.MODULE$ : (Opcode$.MODULE$.isControl$extension(this.opcode()) && !this.fin() ? FrameParser$FalseFinControlFrame$.MODULE$ : FrameParser$ExpectMasked$.MODULE$);
        } else if (FrameParser$ExpectMasked$.MODULE$.equals(state3)) {
            State state4;
            byte b1 = input.next();
            this.isMasked_$eq((b1 & 0x80) != 0);
            int n = b1 & 0x7F;
            switch (n) {
                default: {
                    state4 = this.parsePayloadLen(input, 0L, n);
                    break;
                }
                case 127: {
                    state4 = FrameParser$ExpectLongPayloadLen$.MODULE$;
                    break;
                }
                case 126: {
                    state4 = FrameParser$ExpectShortPayloadLen$.MODULE$;
                }
            }
            state2 = state4;
        } else if (state3 instanceof ExpectPayloadLen && !(option2 = FrameParser$ExpectPayloadLen$.MODULE$.unapply(expectPayloadLen = (ExpectPayloadLen)state3)).isEmpty()) {
            long n = BoxesRunTime.unboxToLong((Object)option2.get());
            state2 = this.parsePayloadLen(input, n, this.parsePayloadLen$default$3());
        } else if (state3 instanceof FrameParser$ExpectMaskingKey$ && !(option = FrameParser$ExpectMaskingKey$.MODULE$.unapply(frameParser$ExpectMaskingKey$ = (FrameParser$ExpectMaskingKey$)state3)).isEmpty()) {
            long n = BoxesRunTime.unboxToLong((Object)option.get());
            this.maskingKey_$eq((byte[])Array$.MODULE$.ofDim((int)n, ClassTag$.MODULE$.Byte()));
            input.getBytes(this.maskingKey());
            state2 = new ExpectData(this.payloadLen());
        } else if (state3 instanceof ExpectData) {
            ExpectData expectData = (ExpectData)state3;
            long n = expectData.nBytes();
            byte[] payload = (byte[])Array$.MODULE$.ofDim((int)n, ClassTag$.MODULE$.Byte());
            input.getBytes(payload);
            Object object = this.isMasked() ? (Object)Frame$.MODULE$.maskData(payload, this.maskingKey()) : BoxedUnit.UNIT;
            state2 = new Success(Frame$.MODULE$.apply(this.finRsvOp(), ByteString$.MODULE$.apply(payload)));
        } else {
            state2 = state3;
        }
        return state2;
    }

    private State parsePayloadLen(ByteIterator input, long nBytes, int len) {
        long l;
        block12: {
            State state;
            long l2;
            block10: {
                block11: {
                    block9: {
                        l = nBytes;
                        if (0L != l) break block9;
                        l2 = len;
                        break block10;
                    }
                    if (2L != l) break block11;
                    l2 = input.getShort(Frame$.MODULE$.byteOrder()) & 0xFFFF;
                    break block10;
                }
                if (8L != l) break block12;
                l2 = input.getLong(Frame$.MODULE$.byteOrder());
            }
            this.payloadLen_$eq(l2);
            if (this.payloadLen() > FrameParser$.MODULE$.frameSizeLimit()) {
                state = FrameParser$OversizedDataFrame$.MODULE$;
            } else if (Opcode$.MODULE$.isControl$extension(this.opcode()) && this.payloadLen() > 125L) {
                state = FrameParser$OversizedControlFrame$.MODULE$;
            } else if (this.isMasked()) {
                state = FrameParser$ExpectMaskingKey$.MODULE$;
            } else {
                this.maskingKey_$eq((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
                state = new ExpectData(this.payloadLen());
            }
            return state;
        }
        throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
    }

    private int parsePayloadLen$default$3() {
        return -1;
    }

    public static interface State {
        public long nBytes();
    }

    public static abstract class Failure
    implements State {
        private final short statusCode;
        private final String reason;

        public short statusCode() {
            return this.statusCode;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public long nBytes() {
            return 0L;
        }

        public Failure(short statusCode, String reason) {
            this.statusCode = statusCode;
            this.reason = reason;
        }
    }

    public static final class Success
    implements State,
    Product,
    Serializable {
        private final Frame frame;

        public Frame frame() {
            return this.frame;
        }

        @Override
        public long nBytes() {
            return 0L;
        }

        public Success copy(Frame frame) {
            return new Success(frame);
        }

        public Frame copy$default$1() {
            return this.frame();
        }

        public String productPrefix() {
            return "Success";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.frame();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Success;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Success)) return false;
            boolean bl = true;
            if (!bl) return false;
            Success success = (Success)x$1;
            Frame frame = this.frame();
            Frame frame2 = success.frame();
            if (frame != null) {
                if (!((Object)frame).equals(frame2)) return false;
                return true;
            }
            if (frame2 == null) return true;
            return false;
        }

        public Success(Frame frame) {
            this.frame = frame;
            Product.class.$init$((Product)this);
        }
    }

    public static final class ExpectData
    implements State,
    Product,
    Serializable {
        private final long nBytes;

        @Override
        public long nBytes() {
            return this.nBytes;
        }

        public ExpectData copy(long nBytes) {
            return new ExpectData(nBytes);
        }

        public long copy$default$1() {
            return this.nBytes();
        }

        public String productPrefix() {
            return "ExpectData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return BoxesRunTime.boxToLong((long)this.nBytes());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectData;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nBytes()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectData)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectData expectData = (ExpectData)x$1;
            if (this.nBytes() != expectData.nBytes()) return false;
            return true;
        }

        public ExpectData(long nBytes) {
            this.nBytes = nBytes;
            Product.class.$init$((Product)this);
        }
    }

    public static interface ExpectPayloadLen
    extends State {
    }
}

